/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.brokermanager.core.internal.registry;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.brokermanager.core.BrokerConfiguration;
import org.wso2.carbon.brokermanager.core.exception.BMConfigurationException;
import org.wso2.carbon.brokermanager.core.internal.util.RegistryHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class BrokerConfigurationRegistryInvoker {
    private static final Log log = LogFactory.getLog(BrokerConfigurationRegistryInvoker.class);
    private static final String BROKER_BASE = "/Brokers";

    public BrokerConfigurationRegistryInvoker(int tenantId) throws BMConfigurationException {
        Registry registry;
        try {
            registry = RegistryHolder.getInstance().getRegistry(tenantId);
        }
        catch (RegistryException e) {
            log.error((Object)"Error in getting registry for the super tenant");
            throw new BMConfigurationException("Error in getting registry for the super tenant", e);
        }
        try {
            if (!registry.resourceExists(BROKER_BASE)) {
                registry.put(BROKER_BASE, (Resource)registry.newCollection());
            }
        }
        catch (RegistryException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Failed to create new collection in registry", (Throwable)e);
            }
            throw new BMConfigurationException("Failed to create new collection in registry", e);
        }
    }

    public void saveConfigurationToRegistry(BrokerConfiguration brokerConfiguration, int tenantId) throws BMConfigurationException {
        String brokerName = brokerConfiguration.getName();
        String pathToBroker = "/Brokers/" + brokerName;
        Resource brokerResource = null;
        Registry registry = null;
        try {
            registry = RegistryHolder.getInstance().getRegistry(tenantId);
        }
        catch (RegistryException e) {
            log.error((Object)("Error in getting registry for the tenant :" + tenantId), (Throwable)e);
            throw new BMConfigurationException("Error in getting registry for the tenant :" + tenantId, e);
        }
        try {
            brokerResource = registry.newResource();
            Map<String, String> propertyMap = brokerConfiguration.getProperties();
            brokerResource.addProperty("name", brokerConfiguration.getName());
            brokerResource.addProperty("type", brokerConfiguration.getType());
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                brokerResource.addProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (RegistryException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Failed to create new resource in registry", (Throwable)e);
            }
            throw new BMConfigurationException("Failed to create new resource in registry", e);
        }
        try {
            registry.put(pathToBroker, brokerResource);
        }
        catch (RegistryException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Failed to saveConfigurationToRegistry new resource in registry", (Throwable)e);
            }
            throw new BMConfigurationException("Failed to saveConfigurationToRegistry new resource in registry", e);
        }
    }

    public void removeConfigurationFromRegistry(String name, int tenantId) throws BMConfigurationException {
        String pathToBroker = "/Brokers/" + name;
        try {
            Registry registry = RegistryHolder.getInstance().getRegistry(tenantId);
            if (registry.resourceExists(pathToBroker)) {
                registry.delete(pathToBroker);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Broker configuration with name " + name + " successfully removed from registry."));
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("No such broker configuration exists to delete. requested broker for delete " + name));
            }
        }
        catch (RegistryException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to removeConfigurationFromRegistry " + name + " from registry."));
            }
            throw new BMConfigurationException("Failed to removeConfigurationFromRegistry " + name + " from registry.", e);
        }
    }

    public Map<String, BrokerConfiguration> getAllBrokerConfigurations(int tenantId) throws BMConfigurationException {
        ConcurrentHashMap<String, BrokerConfiguration> brokerConfigurationMap = new ConcurrentHashMap<String, BrokerConfiguration>();
        try {
            Object resourceContent;
            Registry registry = RegistryHolder.getInstance().getRegistry(tenantId);
            Resource brokerConfigurationsResource = registry.get(BROKER_BASE);
            if (brokerConfigurationsResource != null && (resourceContent = brokerConfigurationsResource.getContent()) instanceof String[]) {
                String[] brokerConfigurationPaths = (String[])resourceContent;
                BrokerConfiguration brokerConfiguration = null;
                for (String brokerConfigurationPath : brokerConfigurationPaths) {
                    brokerConfiguration = new BrokerConfiguration();
                    Resource brokerConfigurationResource = registry.get(brokerConfigurationPath);
                    if (brokerConfigurationResource == null) continue;
                    Properties propertiesHashTable = brokerConfigurationResource.getProperties();
                    Enumeration e = ((Hashtable)propertiesHashTable).keys();
                    while (e.hasMoreElements()) {
                        String propertyName = (String)e.nextElement();
                        ArrayList propertyValueList = (ArrayList)((Hashtable)propertiesHashTable).get(propertyName);
                        String propertyValue = propertyValueList.get(0).toString();
                        if ("name".equals(propertyName)) {
                            brokerConfiguration.setName(propertyValue);
                            continue;
                        }
                        if ("type".equals(propertyName)) {
                            brokerConfiguration.setType(propertyValue);
                            continue;
                        }
                        brokerConfiguration.addProperty(propertyName, propertyValue);
                    }
                    brokerConfigurationMap.put(brokerConfiguration.getName(), brokerConfiguration);
                }
            }
        }
        catch (RegistryException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Failed to get resource with path /Brokers");
            }
            throw new BMConfigurationException("Failed to get resource with path /Brokers", e);
        }
        return brokerConfigurationMap;
    }
}

