/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.brokermanager.core.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.brokermanager.core.BrokerManagerService;
import org.wso2.carbon.brokermanager.core.internal.build.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.brokermanager.core.internal.build.BrokerManagerServiceBuilder;
import org.wso2.carbon.brokermanager.core.internal.util.RegistryHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class BrokerManagerDS {
    private static final Log log = LogFactory.getLog(BrokerManagerDS.class);

    protected void activate(ComponentContext context) {
        try {
            BrokerManagerService brokerProxyService = BrokerManagerServiceBuilder.createBrokerManagerService();
            context.getBundleContext().registerService(BrokerManagerService.class.getName(), (Object)brokerProxyService, null);
            this.registerAxis2ConfigurationContextObserver(context);
            log.info((Object)"Successfully deployed the broker manager service");
        }
        catch (Throwable e) {
            log.error((Object)"Can not create the broker manager service ", e);
        }
    }

    protected void setRegistryService(RegistryService registryService) throws RegistryException {
        RegistryHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryHolder.getInstance().unSetRegistryService();
    }

    private void registerAxis2ConfigurationContextObserver(ComponentContext context) {
        context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(), null);
    }
}

