/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.brokermanager.core.internal.build;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.brokermanager.core.BrokerManagerService;
import org.wso2.carbon.brokermanager.core.exception.BMConfigurationException;
import org.wso2.carbon.brokermanager.core.internal.CarbonBrokerManagerService;
import org.wso2.carbon.brokermanager.core.internal.config.BrokerConfigurationHelper;
import org.wso2.carbon.context.CarbonContext;

public class BrokerManagerServiceBuilder {
    private static final Log log = LogFactory.getLog(BrokerManagerServiceBuilder.class);
    private static CarbonBrokerManagerService carbonBrokerManagerService;

    public static BrokerManagerService createBrokerManagerService() throws BMConfigurationException {
        carbonBrokerManagerService = new CarbonBrokerManagerService();
        carbonBrokerManagerService.loadConfigurations(-1234);
        OMElement brokerManagerConfig = BrokerManagerServiceBuilder.loadConfigXML();
        if (brokerManagerConfig != null) {
            if (!brokerManagerConfig.getQName().equals(new QName("http://wso2.org/carbon/brokermanager", "brokerManagerConfiguration"))) {
                throw new BMConfigurationException("Invalid root element " + brokerManagerConfig.getQName());
            }
            Iterator brokersIter = brokerManagerConfig.getChildrenWithName(new QName("http://wso2.org/carbon/brokermanager", "brokerConfiguraton"));
            while (brokersIter.hasNext()) {
                OMElement brokerOMElement = (OMElement)brokersIter.next();
                carbonBrokerManagerService.addBrokerConfigurationForSuperTenant(BrokerConfigurationHelper.fromOM(brokerOMElement));
            }
        }
        return carbonBrokerManagerService;
    }

    private static OMElement loadConfigXML() throws BMConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "broker-manager-config.xml";
        File configFile = new File(path);
        if (!configFile.exists()) {
            log.info((Object)"The broker-manager-config.xml can not found ");
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(configFile));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new BMConfigurationException(" carbon.xml cannot be found in the path : " + path, e);
        }
        catch (XMLStreamException e) {
            throw new BMConfigurationException("Invalid XML for carbon.xml located in the path : " + path, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {
                throw new BMConfigurationException("Can not close the input stream");
            }
        }
    }

    public static void loadConfigurationsFromRegistry() {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            carbonBrokerManagerService.loadConfigurations(tenantId);
        }
        catch (BMConfigurationException e) {
            log.error((Object)("Error in loading configurations for the tenant :" + tenantId), (Throwable)e);
        }
    }
}

