/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.brokermanager.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.brokermanager.core.BrokerConfiguration;
import org.wso2.carbon.brokermanager.core.BrokerManagerService;
import org.wso2.carbon.brokermanager.core.exception.BMConfigurationException;
import org.wso2.carbon.brokermanager.core.internal.registry.BrokerConfigurationRegistryInvoker;

public class CarbonBrokerManagerService
implements BrokerManagerService {
    private static final Log log = LogFactory.getLog(CarbonBrokerManagerService.class);
    private Map<Integer, Map<String, BrokerConfiguration>> tenantSpecificBrokerConfigurationMap = new ConcurrentHashMap<Integer, Map<String, BrokerConfiguration>>();
    private BrokerConfigurationRegistryInvoker brokerConfigurationRegistryInvoker;

    public void loadConfigurations(int tenantId) throws BMConfigurationException {
        this.brokerConfigurationRegistryInvoker = new BrokerConfigurationRegistryInvoker(tenantId);
        if (this.brokerConfigurationRegistryInvoker.getAllBrokerConfigurations(tenantId).size() > 0) {
            this.tenantSpecificBrokerConfigurationMap.put(tenantId, this.brokerConfigurationRegistryInvoker.getAllBrokerConfigurations(tenantId));
        }
    }

    @Override
    public void addBrokerConfiguration(BrokerConfiguration brokerConfiguration, int tenantId) throws BMConfigurationException {
        Map<String, BrokerConfiguration> brokerConfigurationMap = this.tenantSpecificBrokerConfigurationMap.get(tenantId);
        if (brokerConfigurationMap == null) {
            brokerConfigurationMap = new ConcurrentHashMap<String, BrokerConfiguration>();
            brokerConfigurationMap.put(brokerConfiguration.getName(), brokerConfiguration);
            this.tenantSpecificBrokerConfigurationMap.put(tenantId, brokerConfigurationMap);
        } else {
            brokerConfigurationMap.put(brokerConfiguration.getName(), brokerConfiguration);
        }
        this.brokerConfigurationRegistryInvoker.saveConfigurationToRegistry(brokerConfiguration, tenantId);
    }

    public void addBrokerConfigurationForSuperTenant(BrokerConfiguration brokerConfiguration) throws BMConfigurationException {
        Map<String, BrokerConfiguration> brokerConfigurationMap = this.tenantSpecificBrokerConfigurationMap.get(-1234);
        if (brokerConfigurationMap == null) {
            brokerConfigurationMap = new ConcurrentHashMap<String, BrokerConfiguration>();
            brokerConfigurationMap.put(brokerConfiguration.getName(), brokerConfiguration);
            this.tenantSpecificBrokerConfigurationMap.put(-1234, brokerConfigurationMap);
        } else {
            brokerConfigurationMap.put(brokerConfiguration.getName(), brokerConfiguration);
        }
        this.brokerConfigurationRegistryInvoker.saveConfigurationToRegistry(brokerConfiguration, -1234);
    }

    @Override
    public void removeBrokerConfiguration(String name, int tenantId) throws BMConfigurationException {
        this.tenantSpecificBrokerConfigurationMap.get(tenantId).remove(name);
        this.brokerConfigurationRegistryInvoker.removeConfigurationFromRegistry(name, tenantId);
    }

    @Override
    public List<BrokerConfiguration> getAllBrokerConfigurations(int tenantId) {
        ArrayList<BrokerConfiguration> brokerConfigurations = new ArrayList<BrokerConfiguration>();
        if (this.tenantSpecificBrokerConfigurationMap.get(tenantId) != null) {
            for (BrokerConfiguration brokerConfiguration : this.tenantSpecificBrokerConfigurationMap.get(tenantId).values()) {
                brokerConfigurations.add(brokerConfiguration);
            }
        }
        return brokerConfigurations;
    }

    @Override
    public List<String> getAllBrokerConfigurationNames(int tenantId) {
        ArrayList<String> brokerProxyNames = new ArrayList<String>();
        if (this.tenantSpecificBrokerConfigurationMap.get(tenantId) != null) {
            for (BrokerConfiguration brokerConfiguration : this.tenantSpecificBrokerConfigurationMap.get(tenantId).values()) {
                brokerProxyNames.add(brokerConfiguration.getName());
            }
        }
        return brokerProxyNames;
    }

    @Override
    public BrokerConfiguration getBrokerConfiguration(String name, int tenantId) {
        if (this.tenantSpecificBrokerConfigurationMap.get(tenantId) == null) {
            try {
                this.loadConfigurations(tenantId);
            }
            catch (BMConfigurationException e) {
                log.error((Object)"Error in loading tenant specific broker configurations", (Throwable)e);
            }
        }
        return this.tenantSpecificBrokerConfigurationMap.get(tenantId).get(name);
    }
}

