/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.brokermanager.admin.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.wso2.carbon.broker.core.BrokerTypeDto;
import org.wso2.carbon.broker.core.Property;
import org.wso2.carbon.broker.core.exception.BrokerEventProcessingException;
import org.wso2.carbon.brokermanager.admin.internal.BrokerConfigurationDetails;
import org.wso2.carbon.brokermanager.admin.internal.BrokerProperty;
import org.wso2.carbon.brokermanager.admin.internal.exception.BrokerManagerAdminServiceException;
import org.wso2.carbon.brokermanager.admin.internal.util.BrokerHolder;
import org.wso2.carbon.brokermanager.admin.internal.util.BrokerManagerHolder;
import org.wso2.carbon.brokermanager.core.BrokerConfiguration;
import org.wso2.carbon.brokermanager.core.exception.BMConfigurationException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;

public class BrokerManagerAdminService
extends AbstractAdmin {
    public String[] getBrokerNames() throws BrokerManagerAdminServiceException {
        BrokerHolder brokerHolder = BrokerHolder.getInstance();
        List brokerTypeDtoList = brokerHolder.getBrokerService().getBrokerTypes();
        if (brokerTypeDtoList != null) {
            String[] brokerNames = new String[brokerTypeDtoList.size()];
            for (int index = 0; index < brokerNames.length; ++index) {
                brokerNames[index] = ((BrokerTypeDto)brokerTypeDtoList.get(index)).getName();
            }
            return brokerNames;
        }
        throw new BrokerManagerAdminServiceException("No Broker Names are received.");
    }

    public BrokerProperty[] getBrokerProperties(String brokerName) throws BrokerManagerAdminServiceException {
        BrokerHolder brokerHolder = BrokerHolder.getInstance();
        List brokerTypeDtoList = brokerHolder.getBrokerService().getBrokerTypes();
        for (BrokerTypeDto brokerTypeDto : brokerTypeDtoList) {
            if (!brokerTypeDto.getName().equals(brokerName)) continue;
            List propertyList = brokerTypeDto.getPropertyList();
            BrokerProperty[] brokerPropertyArray = new BrokerProperty[propertyList.size()];
            for (int index = 0; index < brokerPropertyArray.length; ++index) {
                Property property = (Property)propertyList.get(index);
                brokerPropertyArray[index] = new BrokerProperty(property.getPropertyName(), "");
                brokerPropertyArray[index].setRequired(property.isRequired());
                brokerPropertyArray[index].setSecured(property.isSecured());
                brokerPropertyArray[index].setDisplayName(property.getDisplayName());
            }
            return brokerPropertyArray;
        }
        throw new BrokerManagerAdminServiceException("No Broker Properties are received.");
    }

    public void addBrokerConfiguration(String brokerName, String brokerType, BrokerProperty[] properties) throws BrokerManagerAdminServiceException {
        BrokerManagerHolder brokerManager = BrokerManagerHolder.getInstance();
        BrokerConfiguration brokerConfiguration = new BrokerConfiguration();
        brokerConfiguration.setName(brokerName);
        brokerConfiguration.setType(brokerType);
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        for (BrokerProperty brokerProperty : properties) {
            brokerConfiguration.addProperty(brokerProperty.getKey(), brokerProperty.getValue());
        }
        try {
            brokerManager.getBrokerManagerService().addBrokerConfiguration(brokerConfiguration, tenantId);
            this.testBrokerConfiguration(brokerName);
        }
        catch (BMConfigurationException e) {
            throw new BrokerManagerAdminServiceException("Error in adding broker Configuration", e);
        }
    }

    public void removeBrokerConfiguration(String brokerName) throws BrokerManagerAdminServiceException {
        BrokerManagerHolder brokerManager = BrokerManagerHolder.getInstance();
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            brokerManager.getBrokerManagerService().removeBrokerConfiguration(brokerName, tenantId);
        }
        catch (BMConfigurationException e) {
            throw new BrokerManagerAdminServiceException("Error in removing broker configurations" + (Object)((Object)e));
        }
    }

    public BrokerConfigurationDetails[] getAllBrokerConfigurationNamesAndTypes() throws BrokerManagerAdminServiceException {
        BrokerManagerHolder brokerManager = BrokerManagerHolder.getInstance();
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        List brokerConfigurationList = brokerManager.getBrokerManagerService().getAllBrokerConfigurations(tenantId);
        if (brokerConfigurationList != null) {
            BrokerConfigurationDetails[] brokerConfigurationDetailsArray = new BrokerConfigurationDetails[brokerConfigurationList.size()];
            for (int index = 0; index < brokerConfigurationDetailsArray.length; ++index) {
                BrokerConfiguration brokerConfiguration = (BrokerConfiguration)brokerConfigurationList.get(index);
                String brokerName = brokerConfiguration.getName();
                String brokerType = brokerConfiguration.getType();
                Map propertiesMap = brokerConfiguration.getProperties();
                brokerConfigurationDetailsArray[index] = new BrokerConfigurationDetails(brokerName, brokerType, propertiesMap.size());
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    brokerConfigurationDetailsArray[index].addBrokerProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            return brokerConfigurationDetailsArray;
        }
        throw new BrokerManagerAdminServiceException("No Broker Configurations received.");
    }

    public BrokerProperty[] getBrokerConfiguration(String brokerName) throws BrokerManagerAdminServiceException {
        BrokerManagerHolder brokerManager = BrokerManagerHolder.getInstance();
        BrokerHolder brokerHolder = BrokerHolder.getInstance();
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        BrokerConfiguration brokerConfiguration = brokerManager.getBrokerManagerService().getBrokerConfiguration(brokerName, tenantId);
        if (brokerConfiguration != null) {
            String brokerType = brokerConfiguration.getType();
            List propertyList = brokerHolder.getBrokerService().getBrokerProperties(brokerType);
            Map brokerProperties = brokerConfiguration.getProperties();
            BrokerProperty[] brokerPropertyArray = new BrokerProperty[brokerProperties.size()];
            int index = 0;
            for (Property property : propertyList) {
                brokerPropertyArray[index] = new BrokerProperty(property.getPropertyName(), (String)brokerProperties.get(property.getPropertyName()));
                brokerPropertyArray[index].setSecured(property.isSecured());
                brokerPropertyArray[index].setRequired(property.isRequired());
                brokerPropertyArray[index].setDisplayName(property.getDisplayName());
                ++index;
            }
            return brokerPropertyArray;
        }
        throw new BrokerManagerAdminServiceException("No such broker exists.");
    }

    private void testBrokerConfiguration(String brokerName) throws BrokerManagerAdminServiceException {
        BrokerHolder brokerHolder = BrokerHolder.getInstance();
        BrokerManagerHolder brokerManager = BrokerManagerHolder.getInstance();
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        BrokerConfiguration brokerConfiguration = brokerManager.getBrokerManagerService().getBrokerConfiguration(brokerName, tenantId);
        org.wso2.carbon.broker.core.BrokerConfiguration configuration = new org.wso2.carbon.broker.core.BrokerConfiguration();
        configuration.setName(brokerConfiguration.getName());
        configuration.setType(brokerConfiguration.getType());
        configuration.setProperties(brokerConfiguration.getProperties());
        XMLStreamReader reader1 = null;
        String testMessage = " <brokerConfigurationTest>\n   <message>This is a test message.</message>\n   </brokerConfigurationTest>";
        try {
            reader1 = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(testMessage.getBytes()));
            StAXOMBuilder builder1 = new StAXOMBuilder(reader1);
            brokerHolder.getBrokerService().publish(configuration, "test", (Object)builder1.getDocumentElement());
        }
        catch (XMLStreamException e) {
            this.removeBrokerConfiguration(brokerName);
            throw new BrokerManagerAdminServiceException("Failed to prepare test message to  publish to broker:" + brokerName, e);
        }
        catch (BrokerEventProcessingException e) {
            this.removeBrokerConfiguration(brokerName);
            throw new BrokerManagerAdminServiceException("Error at testing broker configuration with name" + brokerName + ". " + e.getMessage(), e);
        }
    }
}

