/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;

public class ActivityLifeCycleEventsDocumentBuilder
implements BpelEventListener {
    private EventInfoListDocument activityLifeCycleEvents = EventInfoListDocument.Factory.newInstance();

    public EventInfoListDocument getActivityLifeCycleEvents() {
        return this.activityLifeCycleEvents;
    }

    public void onEvent(BpelEvent bpelEvent) {
        if (bpelEvent instanceof ActivityEvent) {
            ActivityEvent event = (ActivityEvent)bpelEvent;
            this.fillEventInfo(event);
        }
    }

    private void fillEventInfo(ActivityEvent event) {
        TEventInfoList aEventList = this.activityLifeCycleEvents.getEventInfoList();
        if (aEventList == null) {
            aEventList = TEventInfoList.Factory.newInstance();
            this.activityLifeCycleEvents.setEventInfoList(aEventList);
            aEventList = this.activityLifeCycleEvents.getEventInfoList();
        }
        TEventInfo eventInfo = aEventList.addNewEventInfo();
        eventInfo.setName(this.getClassName(BpelEvent.eventName((BpelEvent)event)));
        eventInfo.setLineNumber(event.getLineNo());
        eventInfo.setTimestamp(this.convertDatetoCalendar(event.getTimestamp()));
        eventInfo.setType(event.getType().toString());
        eventInfo.setActivityId(event.getActivityId());
        eventInfo.setActivityName(event.getActivityName());
        eventInfo.setActivityType(event.getActivityType());
        eventInfo.setScopeId(event.getScopeId().longValue());
        eventInfo.setScopeName(event.getScopeName());
    }

    private String getClassName(String reflectionName) {
        String[] splitter = reflectionName.split("\\$");
        return splitter[splitter.length - 3];
    }

    private Calendar convertDatetoCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public void startup(Properties properties) {
    }

    public void shutdown() {
    }
}

