/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.config;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.CronExpression;
import org.apache.xmlbeans.XmlException;
import org.wso2.carbon.bpel.config.TBPS;
import org.wso2.carbon.bpel.config.TCleanup;
import org.wso2.carbon.bpel.config.TDataBaseConfig;
import org.wso2.carbon.bpel.config.TEventListeners;
import org.wso2.carbon.bpel.config.TExtensionBundles;
import org.wso2.carbon.bpel.config.TMexInterceptors;
import org.wso2.carbon.bpel.config.TMultithreadedHttpConnectionManagerConfig;
import org.wso2.carbon.bpel.config.TOpenJPAConfig;
import org.wso2.carbon.bpel.config.TProcessDehydration;
import org.wso2.carbon.bpel.config.TSchedule;
import org.wso2.carbon.bpel.config.TSchedules;
import org.wso2.carbon.bpel.config.WSO2BPSDocument;
import org.wso2.carbon.utils.CarbonUtils;

public class BPELServerConfiguration {
    private static final Log log = LogFactory.getLog(BPELServerConfiguration.class);
    private WSO2BPSDocument bpsConfigDocument;
    private DataSourceType dsType = DataSourceType.EMBEDDED;
    private String dataSourceName;
    private String dataSourceJNDIRepoInitialContextFactory;
    private String dataSourceJNDIRepoProviderURL;
    private int processDehydrationMaxAge;
    private boolean isProcessDehydrationEnabled = false;
    private int processDehydraionMaxCount;
    private String transactionFactoryClass = "org.apache.ode.il.EmbeddedGeronimoFactory";
    private List<String> eventListeners = new ArrayList<String>();
    private List<String> mexInterceptors = new ArrayList<String>();
    private List<String> extensionBundleRuntimes = new ArrayList<String>();
    private List<String> extensionCorrelationFilters = new ArrayList<String>();
    private List<String> extensionBundleValidators = new ArrayList<String>();
    private Map<String, String> openJpaProperties = new HashMap<String, String>();
    private int mexTimeOut = 120000;
    private int externalServiceTimeOut = 120000;
    private int maxConnectionsPerHost = 10;
    private int maxTotalConnections = 100;
    private boolean debugOnTransactionManager = false;
    private boolean syncWithRegistry = false;
    private long inMemoryInstanceTTL = 600000L;
    private int odeSchedulerThreadPoolSize = 0;

    public BPELServerConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading bps configuration....");
        }
        this.populateDefaultOpenJPAProps();
        this.loadBPELServerConfigurationFile();
    }

    public DataSourceType getDsType() {
        return this.dsType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataSourceJNDIRepoInitialContextFactory() {
        return this.dataSourceJNDIRepoInitialContextFactory;
    }

    public String getDataSourceJNDIRepoProviderURL() {
        return this.dataSourceJNDIRepoProviderURL;
    }

    public int getProcessDehydrationMaxAge() {
        return this.processDehydrationMaxAge;
    }

    public boolean isProcessDehydrationEnabled() {
        return this.isProcessDehydrationEnabled;
    }

    public int getProcessDehydraionMaxCount() {
        return this.processDehydraionMaxCount;
    }

    public String getTransactionFactoryClass() {
        return this.transactionFactoryClass;
    }

    public List<String> getEventListeners() {
        return this.eventListeners;
    }

    public List<String> getMexInterceptors() {
        return this.mexInterceptors;
    }

    public List<String> getExtensionBundleRuntimes() {
        return this.extensionBundleRuntimes;
    }

    public List<String> getExtensionCorrelationFilters() {
        return this.extensionCorrelationFilters;
    }

    public Map<String, String> getOpenJpaProperties() {
        return this.openJpaProperties;
    }

    public int getMexTimeOut() {
        return this.mexTimeOut;
    }

    public int getExternalServiceTimeOut() {
        return this.externalServiceTimeOut;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public boolean isDebugOnTransactionManager() {
        return this.debugOnTransactionManager;
    }

    public List<ProcessConf.CronJob> getSystemCleanupCronJobs() {
        ArrayList<ProcessConf.CronJob> jobs = new ArrayList<ProcessConf.CronJob>();
        TSchedules schedules = this.bpsConfigDocument.getWSO2BPS().getSchedules();
        if (schedules != null && schedules.getScheduleArray() != null && schedules.getScheduleArray().length > 0) {
            for (TSchedule schedule : schedules.getScheduleArray()) {
                ProcessConf.CronJob job = new ProcessConf.CronJob();
                try {
                    job.setCronExpression(new CronExpression(schedule.getWhen()));
                    for (TCleanup aCleanup : schedule.getCleanupArray()) {
                        ProcessConf.CleanupInfo cleanupInfo = new ProcessConf.CleanupInfo();
                        assert (aCleanup.getFilterArray().length != 0);
                        cleanupInfo.setFilters(Arrays.asList(aCleanup.getFilterArray()));
                        BPELServerConfiguration.processACleanup(cleanupInfo.getCategories(), Arrays.asList(aCleanup.getCategoryArray()));
                        Scheduler.JobDetails runnableDetails = new Scheduler.JobDetails();
                        runnableDetails.getDetailsExt().put("cleanupInfo", cleanupInfo);
                        runnableDetails.getDetailsExt().put("transactionSize", 10);
                        job.getRunnableDetailList().add(runnableDetails);
                        log.info((Object)("SYSTEM CRON configuration added a runtime data cleanup: " + runnableDetails));
                    }
                    jobs.add(job);
                }
                catch (ParseException e) {
                    log.error((Object)("Exception during parsing the schedule cron expression: " + schedule.getWhen() + ", skipped the scheduled job."));
                }
            }
        }
        return jobs;
    }

    public static void processACleanup(Set<ProcessConf.CLEANUP_CATEGORY> categories, List<TCleanup.Category.Enum> categoryList) {
        if (categoryList.isEmpty()) {
            categories.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
        } else {
            for (TCleanup.Category.Enum aCategory : categoryList) {
                if (aCategory == TCleanup.Category.ALL) {
                    categories.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
                    continue;
                }
                categories.add(ProcessConf.CLEANUP_CATEGORY.fromString((String)aCategory.toString()));
            }
        }
    }

    public Properties toODEConfigProperties() {
        Properties odeConfig = new Properties();
        odeConfig.setProperty(BPELServerConfiguration.addPrefix("db.mode"), this.dsType.toString());
        if (this.dsType == DataSourceType.EXTERNAL) {
            odeConfig.setProperty(BPELServerConfiguration.addPrefix("db.ext.dataSource"), this.dataSourceName);
            if (this.dataSourceJNDIRepoInitialContextFactory != null) {
                odeConfig.setProperty(BPELServerConfiguration.addPrefix("ds.lookup.jndi.context.factory"), this.dataSourceJNDIRepoInitialContextFactory);
            }
            if (this.dataSourceJNDIRepoProviderURL != null) {
                odeConfig.setProperty(BPELServerConfiguration.addPrefix("ds.lookup.jndi.provider.url"), this.dataSourceJNDIRepoProviderURL);
            }
        }
        if (this.transactionFactoryClass != null) {
            odeConfig.setProperty(BPELServerConfiguration.addPrefix("tx.factory.class"), this.transactionFactoryClass);
        }
        if (this.openJpaProperties.size() > 0) {
            for (String key : this.openJpaProperties.keySet()) {
                odeConfig.setProperty(key, this.openJpaProperties.get(key));
            }
        }
        boolean acquireTransactionLocks = false;
        odeConfig.setProperty(BPELServerConfiguration.addPrefix("ode.acquireTransactionLocks"), Boolean.toString(acquireTransactionLocks));
        odeConfig.setProperty(BPELServerConfiguration.addPrefix("mex.inmem.ttl"), Long.toString(this.inMemoryInstanceTTL));
        odeConfig.setProperty(BPELServerConfiguration.addPrefix("threads.pool.size"), Integer.toString(this.odeSchedulerThreadPoolSize));
        return odeConfig;
    }

    private void populateDefaultOpenJPAProps() {
        this.openJpaProperties.put("openjpa.FlushBeforeQueries", "true");
    }

    private void loadBPELServerConfigurationFile() {
        String carbonConfigDirPath = CarbonUtils.getCarbonConfigDirPath();
        String bpsConfigPath = carbonConfigDirPath + File.separator + "bps.xml";
        File bpsConfigFile = new File(bpsConfigPath);
        if (!bpsConfigFile.exists()) {
            log.warn((Object)("Cannot find BPEL configuration file: " + bpsConfigPath + " Default values are used."));
            return;
        }
        try {
            this.bpsConfigDocument = WSO2BPSDocument.Factory.parse(bpsConfigFile);
            this.populateFields();
        }
        catch (XmlException e) {
            String errMsg = "BPS configuration parsing exception. bps.xml can be found at " + bpsConfigPath;
            log.error((Object)errMsg);
            throw new RuntimeException(errMsg, e);
        }
        catch (IOException e) {
            String errMsg = "Error reading bps configuration file.bps.xml can be found at " + bpsConfigPath;
            log.error((Object)errMsg);
            throw new RuntimeException(errMsg, e);
        }
    }

    private void populateFields() {
        this.populateDataSourceConfigFields();
        this.populateProcessDehydrationField();
        this.populateTransactionFactoryField();
        this.populateEventListeners();
        this.populateMexInterceptors();
        this.populateExtensionBundleFields();
        this.populateOpenJPAProps();
        this.populateMexTimeoutField();
        this.populateExternalServiceTimeOut();
        this.populateHttpConnectionManagerProperties();
        this.populateDebugOnTransactionManagerProp();
        this.populateSyncWithRegistry();
        this.populateInMemoryInstanceTTL();
        this.populateOdeSchedulerThreadPoolSize();
    }

    private void populateSyncWithRegistry() {
        if (this.bpsConfigDocument.getWSO2BPS().isSetSyncWithRegistry()) {
            this.syncWithRegistry = this.bpsConfigDocument.getWSO2BPS().getSyncWithRegistry();
        }
    }

    private void populateDataSourceConfigFields() {
        TDataBaseConfig databaseConfig = this.bpsConfigDocument.getWSO2BPS().getDataBaseConfig();
        if (databaseConfig != null) {
            TDataBaseConfig.DataSource.JNDI jndiConfig;
            this.dsType = DataSourceType.EXTERNAL;
            if (databaseConfig.getDataSource().getName() == null || databaseConfig.getDataSource().getName().length() <= 0) {
                throw new RuntimeException("Data Source name cannot be null, when data source mode is external.");
            }
            this.dataSourceName = databaseConfig.getDataSource().getName();
            if (databaseConfig.getDataSource().isSetJNDI() && (jndiConfig = databaseConfig.getDataSource().getJNDI()).getContextFactory() != null && jndiConfig.getContextFactory().length() > 0 && jndiConfig.getProviderURL() != null && jndiConfig.getProviderURL().length() > 0) {
                this.dataSourceJNDIRepoInitialContextFactory = jndiConfig.getContextFactory().trim();
                this.dataSourceJNDIRepoProviderURL = jndiConfig.getProviderURL().trim();
                int portOffset = this.readPortOffset();
                String urlWithoutPort = this.dataSourceJNDIRepoProviderURL.substring(0, this.dataSourceJNDIRepoProviderURL.lastIndexOf(58) + 1);
                int dataSourceJNDIRepoProviderPort = Integer.parseInt(this.dataSourceJNDIRepoProviderURL.substring(urlWithoutPort.length())) + portOffset;
                this.dataSourceJNDIRepoProviderURL = urlWithoutPort + dataSourceJNDIRepoProviderPort;
            }
        }
    }

    private int readPortOffset() {
        String offSet = CarbonUtils.getServerConfiguration().getFirstProperty("Ports.Offset");
        try {
            return offSet != null ? Integer.parseInt(offSet.trim()) : 0;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Incorrect port offset: " + offSet + " resetting offset to 0"));
            return 0;
        }
    }

    private void populateProcessDehydrationField() {
        TProcessDehydration processDehydrationConfig = this.bpsConfigDocument.getWSO2BPS().getProcessDehydration();
        if (processDehydrationConfig != null) {
            this.isProcessDehydrationEnabled = processDehydrationConfig.getValue();
            if (processDehydrationConfig.getMaxAge() != null) {
                this.processDehydrationMaxAge = processDehydrationConfig.getMaxAge().getValue();
            }
            this.processDehydraionMaxCount = processDehydrationConfig.getMaxCount();
        }
    }

    private void populateTransactionFactoryField() {
        TBPS.TransactionFactory tfClass = this.bpsConfigDocument.getWSO2BPS().getTransactionFactory();
        if (tfClass != null && tfClass.getClass1() != null && tfClass.getClass1().length() > 0) {
            this.transactionFactoryClass = tfClass.getClass1();
        }
    }

    private void populateEventListeners() {
        TEventListeners eventListenerList = this.bpsConfigDocument.getWSO2BPS().getEventListeners();
        if (eventListenerList != null) {
            for (TEventListeners.Listener listener : eventListenerList.getListenerArray()) {
                this.eventListeners.add(listener.getClass1());
            }
        }
    }

    private void populateMexInterceptors() {
        TMexInterceptors mexInterceptorList = this.bpsConfigDocument.getWSO2BPS().getMexInterceptors();
        if (mexInterceptorList != null) {
            for (TMexInterceptors.Interceptor interceptor : mexInterceptorList.getInterceptorArray()) {
                this.mexInterceptors.add(interceptor.getClass1());
            }
        }
    }

    private void populateExtensionBundleFields() {
        TExtensionBundles extensionBundles = this.bpsConfigDocument.getWSO2BPS().getExtensionBundles();
        if (extensionBundles != null) {
            if (extensionBundles.getRuntimes() != null) {
                for (TExtensionBundles.Runtimes.Runtime runtime : extensionBundles.getRuntimes().getRuntimeArray()) {
                    this.extensionBundleRuntimes.add(runtime.getClass1());
                }
            }
            if (extensionBundles.getFilters() != null) {
                for (TExtensionBundles.Filters.Filter filter : extensionBundles.getFilters().getFilterArray()) {
                    this.extensionCorrelationFilters.add(filter.getClass1());
                }
            }
            if (extensionBundles.getValidators() != null) {
                for (TExtensionBundles.Validators.Validator validator : extensionBundles.getValidators().getValidatorArray()) {
                    this.extensionBundleValidators.add(validator.getClass1());
                }
            }
        }
    }

    private void populateOpenJPAProps() {
        TOpenJPAConfig openJpaConfig = this.bpsConfigDocument.getWSO2BPS().getOpenJPAConfig();
        if (openJpaConfig != null) {
            for (TOpenJPAConfig.Property prop : openJpaConfig.getPropertyArray()) {
                this.openJpaProperties.put(prop.getName(), prop.getValue());
            }
        }
    }

    private void populateMexTimeoutField() {
        TBPS.MexTimeOut timeOut = this.bpsConfigDocument.getWSO2BPS().getMexTimeOut();
        if (timeOut != null) {
            this.mexTimeOut = timeOut.getValue();
        }
    }

    private void populateExternalServiceTimeOut() {
        TBPS.ExternalServiceTimeOut extSvcTimeOut = this.bpsConfigDocument.getWSO2BPS().getExternalServiceTimeOut();
        if (extSvcTimeOut != null) {
            this.externalServiceTimeOut = extSvcTimeOut.getValue();
        }
    }

    private void populateHttpConnectionManagerProperties() {
        TMultithreadedHttpConnectionManagerConfig multiThreadedConManagerConfig = this.bpsConfigDocument.getWSO2BPS().getMultithreadedHttpConnectionManagerConfig();
        if (multiThreadedConManagerConfig != null) {
            this.maxConnectionsPerHost = multiThreadedConManagerConfig.getMaxConnectionsPerHost().getValue();
            this.maxTotalConnections = multiThreadedConManagerConfig.getMaxTotalConnections().getValue();
        }
    }

    private void populateDebugOnTransactionManagerProp() {
        this.debugOnTransactionManager = this.bpsConfigDocument.getWSO2BPS().getDebugTransactions();
    }

    private void populateInMemoryInstanceTTL() {
        if (this.bpsConfigDocument.getWSO2BPS().isSetInMemoryInstanceTimeToLive()) {
            this.inMemoryInstanceTTL = this.bpsConfigDocument.getWSO2BPS().getInMemoryInstanceTimeToLive();
        }
    }

    private void populateOdeSchedulerThreadPoolSize() {
        if (this.bpsConfigDocument.getWSO2BPS().isSetODESchedulerThreadPoolSize()) {
            this.odeSchedulerThreadPoolSize = this.bpsConfigDocument.getWSO2BPS().getODESchedulerThreadPoolSize();
        }
    }

    private static String addPrefix(String prop) {
        return "wso2-bps." + prop;
    }

    public boolean isSyncWithRegistry() {
        return this.syncWithRegistry;
    }

    public static enum DataSourceType {
        EMBEDDED,
        EXTERNAL;

    }
}

