/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.attachment.mgt.server.AttachmentServerService;
import org.wso2.carbon.bpel.core.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.bpel.core.BPELEngineService;
import org.wso2.carbon.bpel.core.BPELEngineServiceImpl;
import org.wso2.carbon.bpel.core.internal.BPELServerHolder;
import org.wso2.carbon.bpel.core.ode.integration.BPELServer;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class BPELServiceComponent {
    private static Log log = LogFactory.getLog(BPELServiceComponent.class);
    private BundleContext bundleContext;
    private boolean dataSourceInfoRepoProvided = false;
    private ServiceRegistration registration;

    protected void activate(ComponentContext ctxt) {
        try {
            this.bundleContext = ctxt.getBundleContext();
            if (this.dataSourceInfoRepoProvided) {
                BPELServiceComponent.initializeBPELServer();
                this.registerAxis2ConfigurationContextObserver();
                this.registerBPELServerService();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate BPEL Core bundle", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"BPEL Core bundle is activated.");
        }
    }

    protected void setDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService bound to the BPEL component");
        }
        this.dataSourceInfoRepoProvided = true;
    }

    protected void unsetDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService unbound from the BPEL component");
        }
        this.dataSourceInfoRepoProvided = false;
    }

    protected void setRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the BPEL component");
        }
        BPELServerHolder.getInstance().setRegistryService(registrySvc);
    }

    protected void unsetRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the BPEL component");
        }
        BPELServerHolder.getInstance().setRegistryService(null);
    }

    public static TenantRegistryLoader getTenantRegistryLoader() {
        return BPELServerHolder.getInstance().getRegistryLoader();
    }

    public static RegistryService getRegistryService() {
        return BPELServerHolder.getInstance().getRegistryService();
    }

    public static BPELServer getBPELServer() {
        return BPELServerHolder.getInstance().getBpelServer();
    }

    private void registerAxis2ConfigurationContextObserver() {
        this.bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(), null);
    }

    private static void initializeBPELServer() throws Exception {
        BPELServerHolder.getInstance().setBpelServer(BPELServerImpl.getInstance());
        log.info((Object)"Initializing BPEL Engine........");
        BPELServerHolder.getInstance().getBpelServer().init();
        Runtime.getRuntime().addShutdownHook(new BPELServerShutDown(BPELServerHolder.getInstance().getBpelServer()));
    }

    private void registerBPELServerService() {
        this.registration = this.bundleContext.registerService(BPELEngineService.class.getName(), (Object)new BPELEngineServiceImpl(), null);
    }

    protected void deactivate(ComponentContext componentContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping the BPEL Core Component");
        }
        componentContext.getBundleContext().ungetService(this.registration.getReference());
    }

    protected void setAttachmentMgtService(AttachmentServerService attMgtService) {
        BPELServerHolder.getInstance().setAttachmentService(attMgtService);
    }

    protected void unsetAttachmentMgtService(AttachmentServerService attMgtService) {
        BPELServerHolder.getInstance().setAttachmentService(null);
    }

    private static final class BPELServerShutDown
    extends Thread {
        private BPELServerImpl bpsServer;

        private BPELServerShutDown(BPELServerImpl bpsServer) {
            this.bpsServer = bpsServer;
        }

        @Override
        public void run() {
            log.info((Object)"Shutting down BPEL Server........");
            try {
                this.bpsServer.shutdown();
            }
            catch (Exception e) {
                log.error((Object)"Error when shutting down BPEL Server.", (Throwable)e);
            }
        }
    }
}

