/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;

public class ClassLoaderDumper {
    public static void dump(Object o) {
        if (o != null) {
            ClassLoaderDumper.dump(o.getClass().getClassLoader());
        }
    }

    public static void dump(Class cls) {
        System.out.println("ClassLoader dump for " + cls.getName());
        ClassLoaderDumper.dump(cls.getClassLoader());
    }

    public static void dump(ClassLoader loader) {
        ClassLoaderDumper.dumpIDs("", loader);
        ClassLoaderDumper.dumpContents("", loader);
    }

    private static void dumpIDs(String prefix, ClassLoader loader) {
        if (loader == null) {
            return;
        }
        System.out.println(prefix + "ClassLoader is " + loader);
        if (loader instanceof MultiParentClassLoader) {
            MultiParentClassLoader mp = (MultiParentClassLoader)loader;
            ClassLoader[] parents = mp.getParents();
            for (int i = 0; i < parents.length; ++i) {
                ClassLoaderDumper.dumpIDs(prefix + "  ", parents[i]);
            }
        } else {
            ClassLoaderDumper.dumpIDs(prefix + "  ", loader.getParent());
        }
    }

    private static void dumpContents(String prefix, ClassLoader loader) {
        int i;
        if (loader == null) {
            return;
        }
        System.out.println(prefix + "ClassLoader is " + loader);
        if (loader instanceof URLClassLoader) {
            URLClassLoader url = (URLClassLoader)loader;
            URL[] entries = url.getURLs();
            for (i = 0; i < entries.length; ++i) {
                URL entry = entries[i];
                System.out.println(prefix + "  " + entry);
            }
        }
        if (loader instanceof MultiParentClassLoader) {
            MultiParentClassLoader mp = (MultiParentClassLoader)loader;
            ClassLoader[] parents = mp.getParents();
            for (i = 0; i < parents.length; ++i) {
                ClassLoaderDumper.dumpContents(prefix + "    ", parents[i]);
            }
        } else {
            ClassLoaderDumper.dumpContents(prefix + "    ", loader.getParent());
        }
    }
}

