/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayLongList;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongListIterator;

public final class LongCollections {
    public static final LongList EMPTY_LONG_LIST = LongCollections.unmodifiableLongList(new ArrayLongList(0));
    public static final LongIterator EMPTY_LONG_ITERATOR = LongCollections.unmodifiableLongIterator(EMPTY_LONG_LIST.iterator());
    public static final LongListIterator EMPTY_LONG_LIST_ITERATOR = LongCollections.unmodifiableLongListIterator(EMPTY_LONG_LIST.listIterator());

    public static LongList singletonLongList(long value) {
        ArrayLongList list = new ArrayLongList(1);
        list.add(value);
        return UnmodifiableLongList.wrap((LongList)list);
    }

    public static LongIterator singletonLongIterator(long value) {
        return LongCollections.singletonLongList(value).iterator();
    }

    public static LongListIterator singletonLongListIterator(long value) {
        return LongCollections.singletonLongList(value).listIterator();
    }

    public static LongList unmodifiableLongList(LongList list) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        return UnmodifiableLongList.wrap((LongList)list);
    }

    public static LongIterator unmodifiableLongIterator(LongIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableLongIterator.wrap((LongIterator)iter);
    }

    public static LongListIterator unmodifiableLongListIterator(LongListIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableLongListIterator.wrap((LongListIterator)iter);
    }

    public static LongList getEmptyLongList() {
        return EMPTY_LONG_LIST;
    }

    public static LongIterator getEmptyLongIterator() {
        return EMPTY_LONG_ITERATOR;
    }

    public static LongListIterator getEmptyLongListIterator() {
        return EMPTY_LONG_LIST_ITERATOR;
    }
}

