/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntListIterator;

public final class IntCollections {
    public static final IntList EMPTY_INT_LIST = IntCollections.unmodifiableIntList(new ArrayIntList(0));
    public static final IntIterator EMPTY_INT_ITERATOR = IntCollections.unmodifiableIntIterator(EMPTY_INT_LIST.iterator());
    public static final IntListIterator EMPTY_INT_LIST_ITERATOR = IntCollections.unmodifiableIntListIterator(EMPTY_INT_LIST.listIterator());

    public static IntList singletonIntList(int value) {
        ArrayIntList list = new ArrayIntList(1);
        list.add(value);
        return UnmodifiableIntList.wrap((IntList)list);
    }

    public static IntIterator singletonIntIterator(int value) {
        return IntCollections.singletonIntList(value).iterator();
    }

    public static IntListIterator singletonIntListIterator(int value) {
        return IntCollections.singletonIntList(value).listIterator();
    }

    public static IntList unmodifiableIntList(IntList list) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        return UnmodifiableIntList.wrap((IntList)list);
    }

    public static IntIterator unmodifiableIntIterator(IntIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableIntIterator.wrap((IntIterator)iter);
    }

    public static IntListIterator unmodifiableIntListIterator(IntListIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableIntListIterator.wrap((IntListIterator)iter);
    }

    public static IntList getEmptyIntList() {
        return EMPTY_INT_LIST;
    }

    public static IntIterator getEmptyIntIterator() {
        return EMPTY_INT_ITERATOR;
    }

    public static IntListIterator getEmptyIntListIterator() {
        return EMPTY_INT_LIST_ITERATOR;
    }
}

