/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleListIterator;

public final class DoubleCollections {
    public static final DoubleList EMPTY_DOUBLE_LIST = DoubleCollections.unmodifiableDoubleList(new ArrayDoubleList(0));
    public static final DoubleIterator EMPTY_DOUBLE_ITERATOR = DoubleCollections.unmodifiableDoubleIterator(EMPTY_DOUBLE_LIST.iterator());
    public static final DoubleListIterator EMPTY_DOUBLE_LIST_ITERATOR = DoubleCollections.unmodifiableDoubleListIterator(EMPTY_DOUBLE_LIST.listIterator());

    public static DoubleList singletonDoubleList(double value) {
        ArrayDoubleList list = new ArrayDoubleList(1);
        list.add(value);
        return UnmodifiableDoubleList.wrap((DoubleList)list);
    }

    public static DoubleIterator singletonDoubleIterator(double value) {
        return DoubleCollections.singletonDoubleList(value).iterator();
    }

    public static DoubleListIterator singletonDoubleListIterator(double value) {
        return DoubleCollections.singletonDoubleList(value).listIterator();
    }

    public static DoubleList unmodifiableDoubleList(DoubleList list) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleList.wrap((DoubleList)list);
    }

    public static DoubleIterator unmodifiableDoubleIterator(DoubleIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleIterator.wrap((DoubleIterator)iter);
    }

    public static DoubleListIterator unmodifiableDoubleListIterator(DoubleListIterator iter) {
        if (null == iter) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleListIterator.wrap((DoubleListIterator)iter);
    }

    public static DoubleList getEmptyDoubleList() {
        return EMPTY_DOUBLE_LIST;
    }

    public static DoubleIterator getEmptyDoubleIterator() {
        return EMPTY_DOUBLE_ITERATOR;
    }

    public static DoubleListIterator getEmptyDoubleListIterator() {
        return EMPTY_DOUBLE_LIST_ITERATOR;
    }
}

