/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common.config;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpointFactory;

public class EndpointConfiguration {
    private String serviceName;
    private String servicePort;
    private String serviceNS;
    private String mexTimeout;
    private String basePath;
    private String unifiedEndPointReference;
    private OMElement uepOM;
    private UnifiedEndpoint unifiedEndpoint = null;
    private boolean serviceDescriptionAvailable;
    private String serviceDescriptionLocation;

    public void setUnifiedEndPointReference(String unifiedEndPointReference) {
        this.unifiedEndPointReference = unifiedEndPointReference;
    }

    public void setUepOM(OMElement uepOM) {
        this.uepOM = uepOM;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(String servicePort) {
        this.servicePort = servicePort;
    }

    public String getServiceNS() {
        return this.serviceNS;
    }

    public void setServiceNS(String serviceNS) {
        this.serviceNS = serviceNS;
    }

    public String getMexTimeout() {
        return this.mexTimeout;
    }

    public void setMexTimeout(String mexTimeout) {
        this.mexTimeout = mexTimeout;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public UnifiedEndpoint getUnifiedEndpoint() throws AxisFault {
        if (this.unifiedEndpoint == null) {
            String secPolicyKey;
            UnifiedEndpointFactory uepFactory = new UnifiedEndpointFactory();
            if (this.uepOM != null || this.unifiedEndPointReference != null) {
                if (this.uepOM != null) {
                    this.unifiedEndpoint = uepFactory.createEndpoint(this.uepOM);
                } else {
                    String uepConfPath = this.unifiedEndPointReference;
                    if (!(uepConfPath.startsWith("gov:") && uepConfPath.startsWith("conf:") && uepConfPath.startsWith("reg:"))) {
                        if (uepConfPath.startsWith("file:")) {
                            uepConfPath = uepConfPath.substring("file:".length());
                        }
                        uepConfPath = EndpointConfiguration.isAbsoutePath(uepConfPath) ? "file:" + uepConfPath : EndpointConfiguration.getAbsolutePath(this.basePath, uepConfPath);
                    }
                    this.unifiedEndpoint = uepFactory.createVirtualEndpoint(uepConfPath);
                }
            } else {
                this.unifiedEndpoint = new UnifiedEndpoint();
                this.unifiedEndpoint.setUepId(this.serviceName);
                this.unifiedEndpoint.setAddressingEnabled(true);
                this.unifiedEndpoint.setAddressingVersion("final");
            }
            if (this.unifiedEndpoint.isSecurityEnabled() && (secPolicyKey = this.unifiedEndpoint.getWsSecPolicyKey()).startsWith("file:")) {
                String secPolicyLocation = secPolicyKey.substring("file:".length());
                secPolicyKey = !EndpointConfiguration.isAbsoutePath(secPolicyLocation) ? EndpointConfiguration.getAbsolutePath(this.basePath, secPolicyLocation) : "file:" + secPolicyLocation;
                this.unifiedEndpoint.setWsSecPolicyKey(secPolicyKey);
            }
        }
        return this.unifiedEndpoint;
    }

    public static String getAbsolutePath(String basePath, String filePath) {
        return "file:" + basePath + File.separator + filePath;
    }

    public static boolean isAbsoutePath(String filePath) {
        return filePath.startsWith("/") || filePath.length() > 1 && filePath.charAt(1) == ':';
    }

    public boolean isServiceDescriptionAvailable() {
        return this.serviceDescriptionAvailable;
    }

    public void setServiceDescriptionAvailable(boolean serviceDescriptionAvailable) {
        this.serviceDescriptionAvailable = serviceDescriptionAvailable;
    }

    public String getServiceDescriptionLocation() {
        return this.serviceDescriptionLocation;
    }

    public void setServiceDescriptionLocation(String serviceDescriptionLocation) {
        this.serviceDescriptionLocation = serviceDescriptionLocation;
    }
}

