/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.common.OMUtils;

public class WSDLAwareMessage {
    private Map<String, OMElement> headerParts = new HashMap<String, OMElement>();
    private Map<String, OMElement> bodyParts = new HashMap<String, OMElement>();
    private String operationName;
    private QName portTypeName;
    private int tenantId;

    public void addBodyPart(String partName, OMElement partElement) {
        this.bodyParts.put(partName, partElement);
    }

    public void addHeaderPart(String partName, OMElement partElement) {
        this.headerParts.put(partName, partElement);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName = portTypeName;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, Element> getBodyPartElements() {
        HashMap<String, Element> messageBodyParts = new HashMap<String, Element>();
        for (Map.Entry<String, OMElement> part : this.bodyParts.entrySet()) {
            messageBodyParts.put(part.getKey(), OMUtils.toDOM(part.getValue()));
        }
        return messageBodyParts;
    }

    public Map<String, Element> getHeaderPartElements() {
        HashMap<String, Element> messageHeaderParts = new HashMap<String, Element>();
        for (Map.Entry<String, OMElement> part : this.headerParts.entrySet()) {
            messageHeaderParts.put(part.getKey(), OMUtils.toDOM(part.getValue()));
        }
        return messageHeaderParts;
    }
}

