/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;

public class ServiceConfigurationUtil {
    private static final Log log = LogFactory.getLog(ServiceConfigurationUtil.class);

    public static void configureService(AxisService axisService, EndpointConfiguration endpointConf, ConfigurationContext configCtx) throws AxisFault {
        OMElement documentEle;
        if (endpointConf != null && endpointConf.isServiceDescriptionAvailable() && StringUtils.isNotEmpty((String)endpointConf.getServiceDescriptionLocation()) && (documentEle = ServiceConfigurationUtil.getServiceElement(endpointConf)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuring service " + axisService.getName() + " using: " + endpointConf.getServiceDescriptionLocation()));
            }
            ServiceBuilder builder = new ServiceBuilder(configCtx, axisService);
            Iterator itr = documentEle.getChildElements();
            while (itr.hasNext()) {
                OMElement serviceEle = (OMElement)itr.next();
                if (!serviceEle.getLocalName().toLowerCase().equals("service") || serviceEle.getAttribute(new QName("name")) == null || !serviceEle.getAttribute(new QName("name")).getAttributeValue().equals(axisService.getName())) continue;
                builder.populateService(serviceEle);
                Parameter param = new Parameter("confgiuredUsingBpelPkgFiles", (Object)"true");
                axisService.addParameter(param);
            }
        }
    }

    private static OMElement getServiceElement(EndpointConfiguration endpointConfig) {
        OMElement serviceElement;
        String serviceDescriptionLocation = endpointConfig.getServiceDescriptionLocation();
        if (!(serviceDescriptionLocation.startsWith("gov:") && serviceDescriptionLocation.startsWith("conf:") && serviceDescriptionLocation.startsWith("reg:"))) {
            if (serviceDescriptionLocation.startsWith("file:")) {
                serviceDescriptionLocation = serviceDescriptionLocation.substring("file:".length());
            }
            serviceDescriptionLocation = EndpointConfiguration.isAbsoutePath(serviceDescriptionLocation) ? "file:" + serviceDescriptionLocation : EndpointConfiguration.getAbsolutePath(endpointConfig.getBasePath(), serviceDescriptionLocation);
            serviceElement = ServiceConfigurationUtil.readServiceElementFromFile(serviceDescriptionLocation);
        } else {
            serviceElement = ServiceConfigurationUtil.readServiceElementFromRegistry(serviceDescriptionLocation);
        }
        return serviceElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMElement readServiceElementFromFile(String fileLocation) {
        OMElement serviceElement = null;
        File serviceDescFile = new File(fileLocation.substring("file:".length()));
        if (serviceDescFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(serviceDescFile);
                StAXOMBuilder omBuilder = new StAXOMBuilder((InputStream)fis);
                serviceElement = omBuilder.getDocumentElement();
            }
            catch (Exception ex) {
                try {
                    log.warn((Object)"File not found");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        return serviceElement;
    }

    private static OMElement readServiceElementFromRegistry(String registryLocation) {
        OMElement serviceElement = null;
        if (registryLocation.startsWith("conf:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            String location = registryLocation.substring(registryLocation.indexOf("conf:") + "conf:".length());
            serviceElement = ServiceConfigurationUtil.loadServiceElement(registry, location);
        } else if (registryLocation.startsWith("gov:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            String location = registryLocation.substring(registryLocation.indexOf("gov:") + "gov:".length());
            serviceElement = ServiceConfigurationUtil.loadServiceElement(registry, location);
        } else if (registryLocation.startsWith("reg:")) {
            Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.LOCAL_REPOSITORY);
            String location = registryLocation.substring(registryLocation.indexOf("reg:") + "reg:".length());
            serviceElement = ServiceConfigurationUtil.loadServiceElement(registry, location);
        } else {
            String errMsg = "Invalid service.xml file location: " + registryLocation;
            log.warn((Object)errMsg);
        }
        return serviceElement;
    }

    private static OMElement loadServiceElement(Registry registry, String location) {
        OMElement serviceElement = null;
        try {
            if (registry.resourceExists(location)) {
                Resource resource = registry.get(location);
                String resourceContent = new String((byte[])resource.getContent());
                serviceElement = new StAXOMBuilder((InputStream)new ByteArrayInputStream(resourceContent.getBytes())).getDocumentElement();
            } else {
                String errMsg = "The resource: " + location + " does not exist.";
                log.warn((Object)errMsg);
            }
        }
        catch (RegistryException e) {
            String errMsg = "Error occurred while creating the OMElement out of service.xml " + location + " to build the BAM server profile: " + location;
            log.warn((Object)errMsg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errMsg = "Error occurred while creating the OMElement out of service.xml location: " + location;
            log.warn((Object)errMsg, (Throwable)e);
        }
        return serviceElement;
    }
}

