/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import javax.xml.namespace.QName;
import org.apache.ode.utils.ISO8601DateParser;

public class XSTypes {
    public static Object toJavaObject(QName type, String value) {
        String foundType = null;
        try {
            if (XSTypes.isDecimal(type)) {
                foundType = "number";
                return Long.valueOf(value);
            }
            if (XSTypes.isFloat(type)) {
                foundType = "double";
                return Double.valueOf(value);
            }
            if (XSTypes.isBoolean(type)) {
                foundType = "boolean";
                return Boolean.valueOf(value);
            }
            if (XSTypes.isFloat(type)) {
                foundType = "double";
                return Double.valueOf(value);
            }
            if (XSTypes.isDate(type)) {
                foundType = "date";
                return ISO8601DateParser.parseCal(value);
            }
            if (XSTypes.isString(type)) {
                foundType = "string";
                return value;
            }
        }
        catch (Exception nfe) {
            throw new IllegalArgumentException("The type " + foundType + " has been detected using the XSD type " + type + " but the parsing failed! The provided value is probably not of the right type:" + nfe.toString());
        }
        throw new IllegalArgumentException("Couldn't find java type for " + type);
    }

    public static boolean isNumber(QName type) {
        try {
            DECIMAL.valueOf(type.getLocalPart().toUpperCase());
            FLOAT.valueOf(type.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isDate(QName type) {
        try {
            DATEBASE.valueOf(type.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isString(QName type) {
        try {
            STRING.valueOf(type.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isDecimal(QName type) {
        try {
            DECIMAL.valueOf(type.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isFloat(QName type) {
        try {
            FLOAT.valueOf(type.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isBoolean(QName type) {
        return "boolean".equals(type.getLocalPart());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DATEBASE {
        DATETIME,
        DATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STRING {
        STRING,
        NORMALIZEDSTRING,
        TOKEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FLOAT {
        FLOAT,
        DOUBLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DECIMAL {
        DECIMAL,
        INTEGER,
        NONPOSITIVEINTEGER,
        LONG,
        NONNEGATIVEINTEGER,
        NEGATIVEINTEGER,
        INT,
        UNSIGNEDLONG,
        POSITIVEINTEGER,
        SHORT,
        BYTE,
        UNSIGNEDINT,
        UNSIGNEDSHORT,
        UNSIGNEDBYTE;

    }
}

