/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    public static final String PROP_MEX_TIMEOUT = "mex.timeout";
    public static final String PROP_P2P_MEX_TIMEOUT = "p2p.mex.timeout";
    public static final int DEFAULT_MEX_TIMEOUT = 120000;
    public static final String PROP_HTTP_CONNECTION_TIMEOUT = "http.connection.timeout";
    public static final String PROP_HTTP_SOCKET_TIMEOUT = "http.socket.timeout";
    public static final String PROP_HTTP_PROTOCOL_VERSION = "http.protocol.version";
    public static final String PROP_HTTP_HEADER_PREFIX = "http.default-headers.";
    public static final String PROP_HTTP_PROXY_PREFIX = "http.proxy.";
    public static final String PROP_HTTP_PROXY_HOST = "http.proxy.host";
    public static final String PROP_HTTP_PROXY_PORT = "http.proxy.port";
    public static final String PROP_HTTP_PROXY_DOMAIN = "http.proxy.domain";
    public static final String PROP_HTTP_PROXY_USER = "http.proxy.user";
    public static final String PROP_HTTP_PROXY_PASSWORD = "http.proxy.password";
    public static final String PROP_HTTP_PROTOCOL_ENCODING = "http.protocol.encoding";
    public static final String PROP_ADDRESS = "address";
    public static final String PROP_HTTP_MAX_REDIRECTS = "http.protocol.max-redirects";
    public static final String PROP_HTTP_REQUEST_CHUNK = "http.request.chunk";
    public static final String PROP_HTTP_REQUEST_GZIP = "http.request.gzip";
    public static final String PROP_HTTP_ACCEPT_GZIP = "http.accept.gzip";
    public static final String PROP_SECURITY_POLICY = "security.policy.file";
    public static final String PROP_JMS_REPLY_DESTINATION = "jms.reply.destination";
    public static final String PROP_JMS_REPLY_TIMEOUT = "jms.reply.timeout";
    public static final String PROP_JMS_DESTINATION_TYPE = "jms.destination.type";
    public static final String PROP_SEND_WS_ADDRESSING_HEADERS = "ws-addressing.headers";
    protected static final Log log = LogFactory.getLog(Properties.class);

    public static Object[] getProxyAndHeaders(Map<String, String> properties) {
        String host;
        ArrayList<Header> headers = null;
        HttpTransportProperties.ProxyProperties proxy = null;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (k.startsWith(PROP_HTTP_HEADER_PREFIX)) {
                if (headers == null) {
                    headers = new ArrayList<Header>();
                }
                String name = k.substring(PROP_HTTP_HEADER_PREFIX.length());
                headers.add(new Header(name, v));
                continue;
            }
            if (!k.startsWith(PROP_HTTP_PROXY_PREFIX)) continue;
            if (proxy == null) {
                proxy = new HttpTransportProperties.ProxyProperties();
            }
            if (PROP_HTTP_PROXY_HOST.equals(k)) {
                proxy.setProxyName(v);
                continue;
            }
            if (PROP_HTTP_PROXY_PORT.equals(k)) {
                proxy.setProxyPort(Integer.parseInt(v));
                continue;
            }
            if (PROP_HTTP_PROXY_DOMAIN.equals(k)) {
                proxy.setDomain(v);
                continue;
            }
            if (PROP_HTTP_PROXY_USER.equals(k)) {
                proxy.setUserName(v);
                continue;
            }
            if (PROP_HTTP_PROXY_PASSWORD.equals(k)) {
                proxy.setPassWord(v);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("Unknown proxy properties [" + k + "]. " + PROP_HTTP_PROXY_PREFIX + " is a refix reserved for proxy properties."));
        }
        if (proxy != null && ((host = proxy.getProxyHostName()) == null || host.length() == 0)) {
            proxy = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Proxy host is null. Proxy will not be taken into account.");
            }
        }
        return new Object[]{proxy, headers};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpClient {
        public static HttpParams translate(Map<String, String> properties) {
            return HttpClient.translate(properties, (HttpParams)new DefaultHttpParams());
        }

        public static HttpParams translate(Map<String, String> properties, HttpParams p) {
            block26: {
                String value;
                block25: {
                    block24: {
                        block23: {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Translating Properties for HttpClient. Properties size=" + properties.size()));
                            }
                            if (properties.isEmpty()) {
                                return p;
                            }
                            p.setParameter("http.protocol.content-charset", (Object)"UTF-8");
                            for (Map.Entry<String, String> e : properties.entrySet()) {
                                p.setParameter(e.getKey(), (Object)e.getValue());
                            }
                            p.setParameter("http.default-headers", new ArrayList());
                            if (properties.containsKey(Properties.PROP_HTTP_CONNECTION_TIMEOUT)) {
                                value = properties.get(Properties.PROP_HTTP_CONNECTION_TIMEOUT);
                                try {
                                    p.setParameter(Properties.PROP_HTTP_CONNECTION_TIMEOUT, (Object)Integer.valueOf(value));
                                }
                                catch (NumberFormatException e) {
                                    if (!log.isWarnEnabled()) break block23;
                                    log.warn((Object)("Mal-formatted Property: [http.connection.timeout=" + value + "] Property will be skipped."));
                                }
                            }
                        }
                        if (properties.containsKey(Properties.PROP_HTTP_SOCKET_TIMEOUT)) {
                            value = properties.get(Properties.PROP_HTTP_SOCKET_TIMEOUT);
                            try {
                                p.setParameter(Properties.PROP_HTTP_SOCKET_TIMEOUT, (Object)Integer.valueOf(value));
                            }
                            catch (NumberFormatException e) {
                                if (!log.isWarnEnabled()) break block24;
                                log.warn((Object)("Mal-formatted Property: [http.socket.timeout=" + value + "] Property will be skipped."));
                            }
                        }
                    }
                    if (properties.containsKey(Properties.PROP_HTTP_PROTOCOL_ENCODING)) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Deprecated property: http.protocol.encoding. Use http.protocol.content-charset");
                        }
                        p.setParameter("http.protocol.content-charset", (Object)properties.get(Properties.PROP_HTTP_PROTOCOL_ENCODING));
                    }
                    if (properties.containsKey("http.protocol.content-charset")) {
                        p.setParameter("http.protocol.content-charset", (Object)properties.get("http.protocol.content-charset"));
                    }
                    if (properties.containsKey(Properties.PROP_HTTP_PROTOCOL_VERSION)) {
                        try {
                            p.setParameter(Properties.PROP_HTTP_PROTOCOL_VERSION, (Object)HttpVersion.parse((String)properties.get(Properties.PROP_HTTP_PROTOCOL_VERSION)));
                        }
                        catch (ProtocolException e) {
                            if (!log.isWarnEnabled()) break block25;
                            log.warn((Object)"Mal-formatted Property: [http.protocol.version]", (Throwable)e);
                        }
                    }
                }
                if (properties.containsKey(Properties.PROP_HTTP_REQUEST_CHUNK)) {
                    p.setBooleanParameter(Properties.PROP_HTTP_REQUEST_CHUNK, Boolean.parseBoolean(properties.get(Properties.PROP_HTTP_REQUEST_CHUNK)));
                }
                if (properties.containsKey(Properties.PROP_HTTP_REQUEST_GZIP) && log.isWarnEnabled()) {
                    log.warn((Object)"Property not supported by HTTP External Services: http.request.gzip");
                }
                if (Boolean.parseBoolean(properties.get(Properties.PROP_HTTP_ACCEPT_GZIP)) && log.isWarnEnabled()) {
                    log.warn((Object)"Property not supported by HTTP External Services: http.accept.gzip");
                }
                if (properties.containsKey(Properties.PROP_HTTP_MAX_REDIRECTS)) {
                    value = properties.get(Properties.PROP_HTTP_MAX_REDIRECTS);
                    try {
                        p.setParameter(Properties.PROP_HTTP_MAX_REDIRECTS, (Object)Integer.valueOf(value));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block26;
                        log.warn((Object)("Mal-formatted Property: [http.protocol.max-redirects=" + value + "] Property will be skipped."));
                    }
                }
            }
            Object[] o = Properties.getProxyAndHeaders(properties);
            HttpTransportProperties.ProxyProperties proxy = (HttpTransportProperties.ProxyProperties)o[0];
            Collection headers = (Collection)o[1];
            if (headers != null && !headers.isEmpty()) {
                ((Collection)p.getParameter("http.default-headers")).addAll(headers);
            }
            if (proxy != null) {
                p.setParameter(Properties.PROP_HTTP_PROXY_PREFIX, (Object)proxy);
            }
            return new UnmodifiableHttpParams(p);
        }

        static class UnmodifiableHttpParams
        implements HttpParams {
            final HttpParams p;

            private UnmodifiableHttpParams(HttpParams p) {
                this.p = p;
            }

            public void setBooleanParameter(String name, boolean value) {
                throw new UnsupportedOperationException();
            }

            public void setDefaults(HttpParams params) {
                throw new UnsupportedOperationException();
            }

            public void setDoubleParameter(String name, double value) {
                throw new UnsupportedOperationException();
            }

            public void setIntParameter(String name, int value) {
                throw new UnsupportedOperationException();
            }

            public void setLongParameter(String name, long value) {
                throw new UnsupportedOperationException();
            }

            public void setParameter(String name, Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean getBooleanParameter(String name, boolean defaultValue) {
                return this.p.getBooleanParameter(name, defaultValue);
            }

            public HttpParams getDefaults() {
                return null;
            }

            public double getDoubleParameter(String name, double defaultValue) {
                return this.p.getDoubleParameter(name, defaultValue);
            }

            public int getIntParameter(String name, int defaultValue) {
                return this.p.getIntParameter(name, defaultValue);
            }

            public long getLongParameter(String name, long defaultValue) {
                return this.p.getLongParameter(name, defaultValue);
            }

            public Object getParameter(String name) {
                return this.p.getParameter(name);
            }

            public boolean isParameterFalse(String name) {
                return this.p.isParameterFalse(name);
            }

            public boolean isParameterSet(String name) {
                return this.p.isParameterSet(name);
            }

            public boolean isParameterSetLocally(String name) {
                return this.p.isParameterSetLocally(name);
            }

            public boolean isParameterTrue(String name) {
                return this.p.isParameterTrue(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Axis2 {
        public static Options translate(Map<String, String> properties) {
            return Axis2.translate(properties, new Options());
        }

        public static Options translate(Map<String, String> properties, Options options) {
            String value;
            block30: {
                block29: {
                    block28: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Translating Properties for Axis2");
                        }
                        if (properties.isEmpty()) {
                            return options;
                        }
                        options.setProperty("CHARACTER_SET_ENCODING", (Object)"UTF-8");
                        for (Map.Entry<String, String> e : properties.entrySet()) {
                            options.setProperty(e.getKey(), (Object)e.getValue());
                        }
                        if (properties.containsKey(Properties.PROP_HTTP_CONNECTION_TIMEOUT)) {
                            value = properties.get(Properties.PROP_HTTP_CONNECTION_TIMEOUT);
                            try {
                                options.setProperty("CONNECTION_TIMEOUT", (Object)Integer.valueOf(value));
                            }
                            catch (NumberFormatException e) {
                                if (!log.isWarnEnabled()) break block28;
                                log.warn((Object)("Mal-formatted Property: [http.connection.timeout=" + value + "]. Integer expected. Property will be skipped."));
                            }
                        }
                    }
                    if (properties.containsKey(Properties.PROP_HTTP_SOCKET_TIMEOUT)) {
                        value = properties.get(Properties.PROP_HTTP_SOCKET_TIMEOUT);
                        try {
                            options.setProperty("SO_TIMEOUT", (Object)Integer.valueOf(value));
                        }
                        catch (NumberFormatException e) {
                            if (!log.isWarnEnabled()) break block29;
                            log.warn((Object)("Mal-formatted Property: [http.socket.timeout=" + value + "]. Integer expected. Property will be skipped."));
                        }
                    }
                }
                if (properties.containsKey(Properties.PROP_HTTP_PROTOCOL_ENCODING)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Deprecated property: http.protocol.encoding. Use http.protocol.content-charset");
                    }
                    options.setProperty("CHARACTER_SET_ENCODING", (Object)properties.get(Properties.PROP_HTTP_PROTOCOL_ENCODING));
                }
                if (properties.containsKey("http.protocol.content-charset")) {
                    options.setProperty("CHARACTER_SET_ENCODING", (Object)properties.get("http.protocol.content-charset"));
                }
                if (properties.containsKey(Properties.PROP_HTTP_PROTOCOL_VERSION)) {
                    options.setProperty("__HTTP_PROTOCOL_VERSION__", (Object)properties.get(Properties.PROP_HTTP_PROTOCOL_VERSION));
                }
                if (properties.containsKey(Properties.PROP_HTTP_REQUEST_CHUNK)) {
                    options.setProperty("__CHUNKED__", (Object)properties.get(Properties.PROP_HTTP_REQUEST_CHUNK));
                }
                if (properties.containsKey(Properties.PROP_HTTP_REQUEST_GZIP)) {
                    options.setProperty("transport.http.gzipRequest", (Object)properties.get(Properties.PROP_HTTP_REQUEST_GZIP));
                }
                if (properties.containsKey(Properties.PROP_HTTP_ACCEPT_GZIP)) {
                    options.setProperty("transport.http.acceptGzip", (Object)properties.get(Properties.PROP_HTTP_ACCEPT_GZIP));
                }
                if (properties.containsKey(Properties.PROP_HTTP_MAX_REDIRECTS) && log.isWarnEnabled()) {
                    log.warn((Object)"Property Not Supported: http.protocol.max-redirects");
                }
                if (properties.containsKey(Properties.PROP_JMS_REPLY_DESTINATION)) {
                    options.setProperty("transport.jms.ReplyDestination", (Object)properties.get(Properties.PROP_JMS_REPLY_DESTINATION));
                }
                if (properties.containsKey(Properties.PROP_JMS_REPLY_TIMEOUT)) {
                    value = properties.get(Properties.PROP_JMS_REPLY_TIMEOUT);
                    options.setProperty("JMS_WAIT_REPLY", (Object)value);
                }
                if (properties.containsKey(Properties.PROP_JMS_DESTINATION_TYPE)) {
                    value = properties.get(Properties.PROP_JMS_DESTINATION_TYPE);
                    try {
                        options.setProperty("transport.jms.DestinationType", (Object)Long.valueOf(value));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block30;
                        log.warn((Object)("Mal-formatted Property: [jms.destination.type=" + value + "]. Long expected. Property will be skipped."));
                    }
                }
            }
            if (properties.containsKey(Properties.PROP_SEND_WS_ADDRESSING_HEADERS)) {
                value = properties.get(Properties.PROP_SEND_WS_ADDRESSING_HEADERS);
                options.setProperty("disableAddressingForOutMessages", (Object)(!Boolean.parseBoolean(value) ? 1 : 0));
            }
            if (properties.containsKey("ws-adddressing.headers")) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Deprecated property: ws-adddressing.headers (Mind the 3 d's). Use ws-addressing.headers");
                }
                options.setProperty("disableAddressingForOutMessages", (Object)(!Boolean.parseBoolean(value = properties.get("ws-adddressing.headers")) ? 1 : 0));
            }
            Object[] o = Properties.getProxyAndHeaders(properties);
            HttpTransportProperties.ProxyProperties proxy = (HttpTransportProperties.ProxyProperties)o[0];
            ArrayList headers = (ArrayList)o[1];
            if (headers != null && !headers.isEmpty()) {
                options.setProperty("HTTP_HEADERS", (Object)headers);
            }
            if (proxy != null) {
                options.setProperty("PROXY", (Object)proxy);
            }
            if (JavaUtils.isTrueExplicitly((Object)options.getProperty("REUSE_HTTP_CLIENT")) && log.isWarnEnabled()) {
                log.warn((Object)"This property cannot be overidden, and must always be false. REUSE_HTTP_CLIENT");
            }
            options.setProperty("REUSE_HTTP_CLIENT", (Object)"false");
            return options;
        }
    }
}

