/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelC;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.WSDLLocatorImpl;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactory4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactoryBPEL20;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.store.DocumentRegistry;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.InternPool;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUnitDir {
    private static Log __log = LogFactory.getLog(DeploymentUnitDir.class);
    private String _name;
    private File _duDirectory;
    private File _descriptorFile;
    private Properties _properties;
    private HashMap<QName, CBPInfo> _processes;
    private HashMap<QName, TDeployment.Process> _processInfo;
    private volatile DeployDocument _dd;
    private volatile DocumentRegistry _docRegistry;
    private long _version;
    private Map<QName, ExtensionValidator> _extensionValidators;
    private static final FileFilter _wsdlFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".wsdl") && path.isFile();
        }
    };
    private static final FileFilter _cbpFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".cbp") && path.isFile();
        }
    };
    private static final FileFilter _bpelFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".bpel") && path.isFile();
        }
    };
    private static final FileFilter _endpointFilter = new FileFilter(){

        public boolean accept(File path) {
            return (path.getName().endsWith(".endpoint") || path.getName().equals("endpoint-configuration.properties")) && path.isFile();
        }
    };

    public DeploymentUnitDir(File dir) {
        block5: {
            this._properties = new Properties();
            this._processes = new HashMap();
            this._processInfo = new HashMap();
            this._version = -1L;
            if (!dir.exists()) {
                throw new IllegalArgumentException("Directory " + dir + " does not exist!");
            }
            this._duDirectory = dir;
            this._name = dir.getName();
            this._descriptorFile = new File(this._duDirectory, "deploy.xml");
            if (!this._descriptorFile.exists()) {
                throw new IllegalArgumentException("Directory " + dir + " does not contain a deploy.xml file!");
            }
            try {
                ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("beans.xml");
                this._properties = (Properties)ctx.getBean("properties");
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Loaded spring properties from file beans.xml:" + this._properties + " for " + this._name));
                }
            }
            catch (Exception e) {
                if (!__log.isDebugEnabled()) break block5;
                __log.debug((Object)("Can't initialize beans.xml application context " + e + " for " + this._name));
            }
        }
    }

    public String getName() {
        return this._duDirectory.getName();
    }

    public void setName(String name) {
        this._name = name;
    }

    public CBPInfo getCBPInfo(QName typeName) {
        return this._processes.get(typeName);
    }

    public void compile() {
        List<File> bpels = FileUtils.directoryEntriesInPath(this._duDirectory, _bpelFilter);
        if (bpels.size() == 0) {
            throw new IllegalArgumentException("Directory " + this._duDirectory.getName() + " does not contain any process!");
        }
        for (File bpel : bpels) {
            String b = bpel.getAbsolutePath();
            File cbp = new File(b.substring(0, b.lastIndexOf(".bpel")) + ".cbp");
            if (!cbp.exists() || cbp.lastModified() < bpel.lastModified()) {
                __log.debug((Object)("compiling " + bpel));
                this.compile(bpel);
                continue;
            }
            __log.debug((Object)("skipping compilation of " + bpel + " cbp found: " + cbp));
        }
    }

    public void scan() {
        HashMap<QName, CBPInfo> processes = new HashMap<QName, CBPInfo>();
        List<File> cbps = FileUtils.directoryEntriesInPath(this._duDirectory, _cbpFilter);
        for (File file : cbps) {
            CBPInfo cbpinfo = this.loadCBPInfo(file);
            processes.put(cbpinfo.processName, cbpinfo);
        }
        this._processes = processes;
        HashMap<QName, TDeployment.Process> processInfo = new HashMap<QName, TDeployment.Process>();
        for (TDeployment.Process p : this.getDeploymentDescriptor().getDeploy().getProcessList()) {
            processInfo.put(p.getName(), p);
        }
        this._processInfo = processInfo;
    }

    public boolean isRemoved() {
        return !this._duDirectory.exists();
    }

    private void compile(final File bpelFile) {
        final BpelC bpelc = BpelC.newBpelCompiler();
        File bpel11wsdl = this.findBpel11Wsdl(bpelFile);
        if (bpel11wsdl != null) {
            bpelc.setProcessWSDL(bpel11wsdl.toURI());
        }
        bpelc.setCompileProperties(this.prepareCompileProperties(bpelFile));
        bpelc.setExtensionValidators(this._extensionValidators);
        bpelc.setBaseDirectory(this._duDirectory);
        InternPool.runBlock(new InternPool.InternableBlock(){

            public void run() {
                try {
                    bpelc.compile(bpelFile, DeploymentUnitDir.this.getVersion());
                }
                catch (IOException e) {
                    __log.error((Object)("Compile error in " + bpelFile), (Throwable)e);
                }
            }
        });
    }

    private CBPInfo loadCBPInfo(File f) {
        FileInputStream is = null;
        try {
            CBPInfo info;
            is = new FileInputStream(f);
            Serializer ofh = new Serializer(is);
            CBPInfo cBPInfo = info = new CBPInfo(ofh.type, ofh.guid, f);
            return cBPInfo;
        }
        catch (Exception e) {
            throw new ContextException("Couldn't read compiled BPEL process " + f.getAbsolutePath(), e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public int hashCode() {
        return this._duDirectory.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeploymentUnitDir)) {
            return false;
        }
        return ((DeploymentUnitDir)obj).getDeployDir().getAbsolutePath().equals(this.getDeployDir().getAbsolutePath());
    }

    public File getDeployDir() {
        return this._duDirectory;
    }

    public List<File> getEndpointConfigFiles() {
        return FileUtils.directoryEntriesInPath(this.getDeployDir(), _endpointFilter);
    }

    public DeployDocument getDeploymentDescriptor() {
        if (this._dd == null) {
            File ddLocation = new File(this._duDirectory, "deploy.xml");
            try {
                XmlOptions options = new XmlOptions();
                HashMap<String, String> otherNs = new HashMap<String, String>();
                otherNs.put("http://ode.fivesight.com/schemas/2006/06/27/dd", "http://www.apache.org/ode/schemas/dd/2007/03");
                options.setLoadSubstituteNamespaces(otherNs);
                this._dd = DeployDocument.Factory.parse(ddLocation, options);
            }
            catch (Exception e) {
                throw new ContextException("Couldn't read deployment descriptor at location " + ddLocation.getAbsolutePath(), e);
            }
        }
        return this._dd;
    }

    public DocumentRegistry getDocRegistry() {
        if (this._docRegistry == null) {
            this._docRegistry = new DocumentRegistry();
            WSDLFactory4BPEL wsdlFactory = (WSDLFactory4BPEL)WSDLFactoryBPEL20.newInstance();
            WSDLReader r = wsdlFactory.newWSDLReader();
            ExtensionRegistry extReg = null;
            try {
                extReg = WSDLFactory.newInstance().newPopulatedExtensionRegistry();
            }
            catch (WSDLException e) {
                throw new ContextException("Could not create ExtensionRegistry.", e);
            }
            extReg.registerExtensionAttributeType(Input.class, new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action"), 0);
            extReg.registerExtensionAttributeType(Output.class, new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action"), 0);
            r.setExtensionRegistry(extReg);
            DefaultResourceFinder rf = new DefaultResourceFinder(this._duDirectory, this._duDirectory);
            URI basedir = this._duDirectory.toURI();
            List<File> wsdls = FileUtils.directoryEntriesInPath(this._duDirectory, _wsdlFilter);
            for (File file : wsdls) {
                URI uri = basedir.relativize(file.toURI());
                try {
                    this._docRegistry.addDefinition((Definition4BPEL)r.readWSDL((WSDLLocator)new WSDLLocatorImpl(rf, uri)));
                }
                catch (WSDLException e) {
                    throw new ContextException("Couldn't read WSDL document at " + uri, e);
                }
            }
        }
        return this._docRegistry;
    }

    public Definition getDefinitionForService(QName name) {
        return this.getDocRegistry().getDefinition(name);
    }

    public Definition getDefinitionForPortType(QName name) {
        return this.getDocRegistry().getDefinitionForPortType(name);
    }

    public Collection<Definition> getDefinitions() {
        Definition4BPEL[] defs = this.getDocRegistry().getDefinitions();
        ArrayList<Definition> ret = new ArrayList<Definition>(defs.length);
        for (Definition4BPEL def : defs) {
            ret.add(def);
        }
        return ret;
    }

    public Set<QName> getProcessNames() {
        return this._processInfo.keySet();
    }

    public String toString() {
        return "{DeploymentUnit " + this._name + "}";
    }

    public TDeployment.Process getProcessDeployInfo(QName type) {
        if (this._processInfo == null) {
            // empty if block
        }
        return this._processInfo.get(type);
    }

    public List<File> allFiles() {
        return this.allFiles(this._duDirectory);
    }

    private List<File> allFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(this.allFiles(file));
            }
            if (file.isHidden() || !file.isFile()) continue;
            result.add(file);
        }
        return result;
    }

    private Map<String, Object> prepareCompileProperties(File bpelFile) {
        List<TDeployment.Process> plist = this.getDeploymentDescriptor().getDeploy().getProcessList();
        for (TDeployment.Process process : plist) {
            if (process.getFileName() == null || "".equals(process.getFileName()) || !bpelFile.getName().equals(process.getFileName())) continue;
            Map<QName, Node> props = ProcessStoreImpl.calcInitialProperties(this._properties, process);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("customProps", props);
            return result;
        }
        return null;
    }

    private File findBpel11Wsdl(File bpelFile) {
        List<TDeployment.Process> plist = this.getDeploymentDescriptor().getDeploy().getProcessList();
        for (TDeployment.Process process : plist) {
            if (process.getFileName() == null || "".equals(process.getFileName()) || !bpelFile.getName().equals(process.getFileName())) continue;
            if (process.getBpel11WsdlFileName() == null || "".equals(process.getBpel11WsdlFileName())) {
                return null;
            }
            return new File(bpelFile.getParentFile(), process.getBpel11WsdlFileName());
        }
        return null;
    }

    public long getVersion() {
        return this._version;
    }

    public long getStaticVersion() {
        return BpelCompiler.getVersion(this.getName());
    }

    public void setVersion(long version) {
        this._version = version;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setExtensionValidators(Map<QName, ExtensionValidator> extensionValidators) {
        this._extensionValidators = extensionValidators;
    }

    public final class CBPInfo {
        final QName processName;
        final String guid;
        final File cbp;

        public CBPInfo(QName processName, String guid, File cbp) {
            this.processName = processName;
            this.guid = guid;
            this.cbp = cbp;
        }

        public File getCbp() {
            return this.cbp;
        }
    }
}

