/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.extension.longrunning;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.runtime.extension.AbstractExtensionCorreationFilter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CorrelationFilter
extends AbstractExtensionCorreationFilter {
    private static Log log = LogFactory.getLog(CorrelationFilter.class);
    public static final String FEEDBACK_HEADER_LOCALNAME = "feedback";
    public static final String FEEDBACK_HEADER_ROLE_URI = "http://schemas.xmlsoap.org/soap/envelope/actor/feedback";
    public static final String FEEDBACK_ATTRIBUTE_NAMESPACE = "http://wso2.org/humantask/feedback";
    public static final String FEEDBACK_ATTRIBUTE_NAME = "taskid";

    public String getNamespaceURI() {
        return "http://wso2.org";
    }

    public void registerExtensionCorrelationFilter() {
        this.registerFilter("sampleFilter", CorrelationFilter.class);
    }

    public String[] computeCorrelationValues(Element body, Element header) {
        String id = this.getTaskID(header);
        if (id == null) {
            id = this.getTaskID(body);
        }
        if (id == null) {
            log.error((Object)"null id");
        } else {
            log.info((Object)("ID: " + id));
        }
        return new String[]{id};
    }

    private String getTaskID(Element envelope) {
        Node nNode;
        NamedNodeMap namedNodeMap;
        String taskID = null;
        NodeList nList = envelope.getElementsByTagNameNS(FEEDBACK_ATTRIBUTE_NAMESPACE, FEEDBACK_HEADER_LOCALNAME);
        if (nList.getLength() > 0 && (namedNodeMap = (nNode = nList.item(0)).getAttributes()).getLength() > 0) {
            Node attr = namedNodeMap.getNamedItemNS(FEEDBACK_ATTRIBUTE_NAMESPACE, FEEDBACK_ATTRIBUTE_NAME);
            taskID = attr.getTextContent();
        }
        if (taskID == null || taskID.equals("")) {
            NodeList nodeList = envelope.getElementsByTagNameNS("http://www.insurance.example.com/claims/schema", "response");
            if (nodeList.getLength() == 1) {
                Node ele = nodeList.item(0);
                taskID = ele.getTextContent();
            } else {
                log.error((Object)"elements are > or < 1");
            }
        }
        return taskID;
    }

    public String getName() {
        return "sampleFilter";
    }
}

