/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.extension.e4x;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.w3c.dom.Node;

public class TopLevelFunctions
extends ImporterTopLevel {
    private static final long serialVersionUID = 1L;
    private static final String[] METHODS = new String[]{"load", "print", "pid", "activityName", "js2dom", "dom2js", "throwFault"};
    private URI _duDir;
    private ExtensionContext _ectx;

    public TopLevelFunctions(ExtensionContext ectx, Context cx, URI duDir) throws Exception {
        super(cx);
        this._duDir = duDir;
        this._ectx = ectx;
        this.defineFunctionProperties(METHODS, TopLevelFunctions.class, 2);
        ScriptableObject.putProperty((Scriptable)this, (String)"_context", (Object)this._ectx);
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(Context.toString((Object)args[i]));
        }
        TopLevelFunctions thiz = (TopLevelFunctions)TopLevelFunctions.getTopLevelScope((Scriptable)thisObj);
        thiz._ectx.printToConsole(sb.toString());
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        TopLevelFunctions thiz = (TopLevelFunctions)TopLevelFunctions.getTopLevelScope((Scriptable)thisObj);
        for (int i = 0; i < args.length; ++i) {
            URI uri = thiz._duDir.resolve(Context.toString((Object)args[i]));
            try {
                InputStream is = uri.toURL().openStream();
                cx.evaluateReader((Scriptable)thiz, (Reader)new InputStreamReader(is), "<importJS>", 1, null);
                continue;
            }
            catch (MalformedURLException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            catch (IOException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    public static long pid(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        TopLevelFunctions thiz = (TopLevelFunctions)TopLevelFunctions.getTopLevelScope((Scriptable)thisObj);
        return thiz._ectx.getProcessId();
    }

    public static String activityName(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        TopLevelFunctions thiz = (TopLevelFunctions)TopLevelFunctions.getTopLevelScope((Scriptable)thisObj);
        return thiz._ectx.getActivityName();
    }

    public static Node js2dom(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1) {
            Context.reportError((String)"js2dom expects one E4X XML parameter");
        }
        return XMLLibImpl.toDomNode((Object)args[0]);
    }

    public static XMLObject dom2js(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1) {
            Context.reportError((String)"dom2js expects one org.w3c.dom.Node parameter");
        }
        TopLevelFunctions thiz = (TopLevelFunctions)TopLevelFunctions.getTopLevelScope((Scriptable)thisObj);
        try {
            Object n = args[0];
            if (n instanceof NativeJavaObject && ((NativeJavaObject)n).unwrap() instanceof Node) {
                n = ((NativeJavaObject)args[0]).unwrap();
            }
            String xml = TopLevelFunctions.domToString((Node)n);
            return (XMLObject)cx.newObject((Scriptable)thiz, "XML", new Object[]{Context.javaToJS((Object)xml, (Scriptable)thiz)});
        }
        catch (TransformerException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public static void throwFault(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws FaultException {
        if (args.length != 3) {
            Context.reportError((String)"throwFault expects the following parameters: throwFault(namespace, localname, faultMessage)");
        }
        String ns = Context.toString((Object)args[0]);
        String localname = Context.toString((Object)args[1]);
        String msg = Context.toString((Object)args[2]);
        throw new FaultException(new QName(ns, localname), msg);
    }

    public static String domToString(Node n) throws TransformerException {
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer idTransform = xformFactory.newTransformer();
        idTransform.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource input = new DOMSource(n);
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        idTransform.transform(input, output);
        return sw.toString();
    }
}

