/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.extension.e4x;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.runtime.extension.AbstractSyncExtensionOperation;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.extension.e4x.TopLevelFunctions;
import org.apache.ode.extension.e4x.VariableDelegator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.xml.XMLLib;
import org.w3c.dom.Element;

public class JSExtensionOperation
extends AbstractSyncExtensionOperation {
    private static final Log __logger = LogFactory.getLog(JSExtensionOperation.class);

    public void runSync(ExtensionContext context, Element element) throws FaultException {
        CustomContextFactory.init();
        Context ctx = ContextFactory.getGlobal().enterContext();
        ctx.setOptimizationLevel(-1);
        ctx.setGeneratingDebug(false);
        ctx.setGeneratingSource(false);
        ctx.setDebugger(null, null);
        try {
            TopLevelFunctions scope = new TopLevelFunctions(context, ctx, context.getDUDir());
            String source = element.getTextContent();
            VariableDelegator delegator = new VariableDelegator((Scriptable)scope, context, ctx);
            ctx.evaluateString((Scriptable)delegator, source, context.getActivityName(), 1, null);
            delegator.writeVariables();
        }
        catch (WrappedException e) {
            __logger.warn((Object)"Error during JS execution.", (Throwable)e);
            if (e.getWrappedException() instanceof FaultException) {
                throw (FaultException)e.getWrappedException();
            }
            throw new FaultException(new QName("ExtensionEvaluationFault", "http://ode.apache.org/extensions/e4x"), e.getMessage());
        }
        catch (FaultException e) {
            __logger.warn((Object)"Fault during JS execution.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            __logger.warn((Object)"Error during JS execution.", (Throwable)e);
            throw new FaultException(new QName("ExtensionEvaluationFault", "http://ode.apache.org/extensions/e4x"), e.getMessage());
        }
        finally {
            Context.exit();
        }
    }

    private static class CustomContextFactory
    extends ContextFactory {
        private CustomContextFactory() {
        }

        protected XMLLib.Factory getE4xImplementationFactory() {
            return XMLLib.Factory.create((String)"org.mozilla.javascript.xmlimpl.XMLLibImpl");
        }

        static void init() {
            if (!ContextFactory.hasExplicitGlobal()) {
                ContextFactory.initGlobal((ContextFactory)new CustomContextFactory());
            }
        }
    }
}

