/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime.extension;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.ExtensionContextImpl;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.w3c.dom.Element;

public abstract class AbstractLongRunningExtensionOperation
extends BpelJacobRunnable
implements ExtensionOperation {
    private static final long serialVersionUID = -82372987878838011L;
    protected static Log _log = LogFactory.getLog(AbstractLongRunningExtensionOperation.class);
    protected ExtensionContext _extensionContext;
    protected String _cid;
    protected Element _element;

    public void setExtensionContext(ExtensionContext extensionContext) {
        this._extensionContext = extensionContext;
    }

    public void setCid(String cid) {
        this._cid = cid;
    }

    public void setElement(Element tempElement) {
        this._element = tempElement;
    }

    public abstract void runAsync(ExtensionContext var1, String var2, Element var3) throws FaultException;

    public void registerForNotification(String notificationChannelId) {
        this._extensionContext.getInternalInstance().registerForExtensionNotification(notificationChannelId, this._extensionContext.getCorrelationValues(), this._extensionContext.getCorrelatorId());
    }

    public abstract void onRequestReceived(String var1) throws FaultException;

    public void updateExtensionContext(BpelRuntimeContext context) {
        ((ExtensionContextImpl)this._extensionContext).setBpelRuntimeContext(context);
    }

    public void run() {
        PickResponseChannel pickResponseChannel = (PickResponseChannel)JacobVPU.activeJacobThread().newChannel(PickResponseChannel.class, this.getClass().getSimpleName(), null);
        try {
            this.runAsync(this._extensionContext, this._cid, this._element);
        }
        catch (FaultException fe) {
            _log.error((Object)"Error occurred in the BPEL extension activity ", (Throwable)fe);
            this._extensionContext.completeWithFault(this._cid, fe);
            return;
        }
        JacobVPU.activeJacobThread().instance(new WAITING(pickResponseChannel, this._extensionContext.getCorrelationValues()));
    }

    public void run(Object context, String cid, Element element) throws FaultException {
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 211L;
        private PickResponseChannel _pickResponseChannel;
        private String[] _correlationValues;
        private AbstractLongRunningExtensionOperation _temp;

        private WAITING(PickResponseChannel pickResponseChannel, String[] correlationValues) {
            this._pickResponseChannel = pickResponseChannel;
            this._correlationValues = correlationValues;
            AbstractLongRunningExtensionOperation.this.registerForNotification(this._pickResponseChannel.export());
        }

        public void run() {
            WAITING.object(false, new PickResponseChannelListener(this._pickResponseChannel){
                private static final long serialVersionUID = -8237296827418738011L;

                public void onRequestRcvd(int selectorIdx, String mexId) {
                    AbstractLongRunningExtensionOperation.this.updateExtensionContext(WAITING.this.getBpelRuntimeContext());
                    try {
                        AbstractLongRunningExtensionOperation.this.onRequestReceived(mexId);
                    }
                    catch (FaultException fe) {
                        _log.error((Object)"Error occurred in the BPEL extension activity, while receiving the response from the external party", (Throwable)fe);
                        AbstractLongRunningExtensionOperation.this._extensionContext.completeWithFault(AbstractLongRunningExtensionOperation.this._cid, fe);
                    }
                }

                public void onTimeout() {
                }

                public void onCancel() {
                    AbstractLongRunningExtensionOperation.this._extensionContext.getParentScopeChannel().completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(AbstractLongRunningExtensionOperation.this._extensionContext.getTerminationChannel()){
                private static final long serialVersionUID = 4399496341785922396L;

                public void terminate() {
                    WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                    1.instance(WAITING.this);
                }
            }));
        }
    }
}

