/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.LinkInfo;
import org.apache.ode.bpel.runtime.SCOPE;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.LinkStatusChannel;
import org.apache.ode.bpel.runtime.channels.LinkStatusChannelListener;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.ReadWriteLockChannel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.SynchChannelListener;
import org.apache.ode.jacob.ValChannel;
import org.apache.ode.jacob.ValChannelListener;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCOPEACT
extends ACTIVITY {
    private static final Log __log = LogFactory.getLog(SCOPEACT.class);
    private static final long serialVersionUID = -4593029783757994939L;

    public SCOPEACT(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
    }

    @Override
    public void run() {
        if (((OScope)this._self.o).isolatedScope) {
            __log.debug((Object)"found ISOLATED scope, instance ISOLATEDGUARD");
            SCOPEACT.instance(new ISOLATEDGUARD(this.createLockList(), this.newChannel(SynchChannel.class)));
        } else {
            LinkFrame linkframe;
            ScopeFrame newFrame = new ScopeFrame((OScope)this._self.o, this.getBpelRuntimeContext().createScopeInstance(this._scopeFrame.scopeInstanceId, (OScope)this._self.o), this._scopeFrame, null);
            if (((OScope)this._self.o).atomicScope && !this._self.o.outgoingLinks.isEmpty()) {
                ValChannel linkInterceptorControl = this.newChannel(ValChannel.class);
                ParentScopeChannel psc = this.newChannel(ParentScopeChannel.class);
                linkframe = this.createInterceptorLinkFrame();
                SCOPEACT.instance(new LINKSTATUSINTERCEPTOR(linkInterceptorControl, linkframe));
                SCOPEACT.instance(new UNLOCKER(psc, this._self.parent, null, Collections.<IsolationLock>emptyList(), linkInterceptorControl));
                this._self.parent = psc;
            } else {
                linkframe = this._linkFrame;
            }
            SCOPEACT.instance(new SCOPE(this._self, newFrame, linkframe));
        }
    }

    private List<IsolationLock> createLockList() {
        LinkedList<IsolationLock> requiredLocks = new LinkedList<IsolationLock>();
        OScope o = (OScope)this._self.o;
        HashSet vrs = new HashSet(o.variableRd);
        vrs.addAll(o.variableWr);
        for (OScope.Variable v : vrs) {
            requiredLocks.add(new IsolationLock(v, o.variableWr.contains(v), this._scopeFrame.globals._varLocks.get(v)));
        }
        Collections.sort(requiredLocks);
        return requiredLocks;
    }

    private LinkFrame createInterceptorLinkFrame() {
        LinkFrame newframe = new LinkFrame(this._linkFrame);
        for (OLink outlink : this._self.o.outgoingLinks) {
            LinkInfo original = this._linkFrame.resolve(outlink);
            LinkStatusChannel newchannel = this.newChannel(LinkStatusChannel.class);
            newframe.links.put(original.olink, new LinkInfo(original.olink, newchannel, newchannel));
        }
        return newframe;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsolationLock
    implements Comparable<IsolationLock>,
    Serializable {
        private static final long serialVersionUID = 4214864393241172705L;
        OScope.Variable guardedObject;
        boolean writeLock;
        ReadWriteLockChannel lockChannel;

        public IsolationLock(OScope.Variable go, boolean writeLock, ReadWriteLockChannel channel) {
            this.guardedObject = go;
            this.writeLock = writeLock;
            this.lockChannel = channel;
        }

        @Override
        public int compareTo(IsolationLock o) {
            return this.guardedObject.getId() - o.guardedObject.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UNLOCKER
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -476393080609348172L;
        private final ParentScopeChannel _self;
        private final ParentScopeChannel _parent;
        private final SynchChannel _synchChannel;
        private final List<IsolationLock> _locks;
        private final ValChannel _linkStatusInterceptor;

        public UNLOCKER(ParentScopeChannel self, ParentScopeChannel parent, SynchChannel synchChannel, List<IsolationLock> locksAcquired, ValChannel linkStatusInterceptor) {
            this._self = self;
            this._parent = parent;
            this._synchChannel = synchChannel;
            this._locks = locksAcquired;
            this._linkStatusInterceptor = linkStatusInterceptor;
        }

        @Override
        public void run() {
            __log.debug((Object)"running UNLOCKER");
            UNLOCKER.object(new ParentScopeChannelListener(this._self){

                @Override
                public void cancelled() {
                    UNLOCKER.this._parent.cancelled();
                    UNLOCKER.this.unlockAll();
                    UNLOCKER.this._linkStatusInterceptor.val(false);
                }

                @Override
                public void compensate(OScope scope, SynchChannel ret) {
                    UNLOCKER.this._parent.compensate(scope, ret);
                    1.instance(UNLOCKER.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                    UNLOCKER.this._parent.completed(faultData, compensations);
                    UNLOCKER.this._linkStatusInterceptor.val(faultData == null);
                    UNLOCKER.this.unlockAll();
                }

                @Override
                public void failure(String reason, Element data) {
                    UNLOCKER.this._parent.failure(reason, data);
                    UNLOCKER.this._linkStatusInterceptor.val(false);
                    UNLOCKER.this.unlockAll();
                }
            });
        }

        private void unlockAll() {
            __log.debug((Object)("UNLOCKER: unlockAll: " + this._locks));
            if (((OScope)SCOPEACT.this._self.o).atomicScope) {
                this.getBpelRuntimeContext().forceFlush();
            }
            for (IsolationLock il : this._locks) {
                il.lockChannel.unlock(this._synchChannel);
            }
            this._locks.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ISOLATEDGUARD
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -5017579415744600900L;
        final List<IsolationLock> _locksNeeded;
        final LinkedList<IsolationLock> _locksAcquired = new LinkedList();
        final SynchChannel _synchChannel;

        ISOLATEDGUARD(List<IsolationLock> locks, SynchChannel synchChannel) {
            this._locksNeeded = locks;
            this._synchChannel = synchChannel;
        }

        @Override
        public void run() {
            if (this._locksNeeded.isEmpty()) {
                __log.debug((Object)("ISOLATIONGUARD: got all required locks: " + this._locksAcquired));
                ScopeFrame newFrame = new ScopeFrame((OScope)SCOPEACT.this._self.o, this.getBpelRuntimeContext().createScopeInstance(SCOPEACT.this._scopeFrame.scopeInstanceId, (OScope)SCOPEACT.this._self.o), SCOPEACT.this._scopeFrame, null);
                ParentScopeChannel parent = SCOPEACT.this._self.parent;
                SCOPEACT.this._self.parent = this.newChannel(ParentScopeChannel.class);
                ValChannel lsi = this.newChannel(ValChannel.class);
                ISOLATEDGUARD.instance(new UNLOCKER(SCOPEACT.this._self.parent, parent, this._synchChannel, this._locksAcquired, lsi));
                LinkFrame linkframe = SCOPEACT.this.createInterceptorLinkFrame();
                ISOLATEDGUARD.instance(new LINKSTATUSINTERCEPTOR(lsi, linkframe));
                ISOLATEDGUARD.instance(new SCOPE(SCOPEACT.this._self, newFrame, linkframe));
                return;
            }
            __log.debug((Object)("ISOLATIONGUARD: don't have all locks still need: " + this._locksNeeded));
            IsolationLock il = this._locksNeeded.get(0);
            if (il.writeLock) {
                il.lockChannel.writeLock(this._synchChannel);
            } else {
                il.lockChannel.readLock(this._synchChannel);
            }
            ISOLATEDGUARD.object(new SynchChannelListener(this._synchChannel){
                private static final long serialVersionUID = 2857261074409098274L;

                public void ret() {
                    __log.debug((Object)("ISOLATIONGUARD: got lock: " + ISOLATEDGUARD.this._locksNeeded.get(0)));
                    ISOLATEDGUARD.this._locksAcquired.add(ISOLATEDGUARD.this._locksNeeded.remove(0));
                    1.instance(ISOLATEDGUARD.this);
                }
            });
        }
    }

    private class LINKSTATUSINTERCEPTOR
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 3104008741240676253L;
        private final ValChannel _self;
        private final LinkFrame _interceptedChannels;
        private final Map<OLink, Boolean> _statuses = new HashMap<OLink, Boolean>();
        private Boolean _status;

        LINKSTATUSINTERCEPTOR(ValChannel self, LinkFrame interceptedChannels) {
            this._self = self;
            this._interceptedChannels = interceptedChannels;
        }

        public void run() {
            __log.debug((Object)"LINKSTATUSINTERCEPTOR: running ");
            HashSet<ChannelListener> mlset = new HashSet<ChannelListener>();
            if (this._status == null) {
                mlset.add(new ValChannelListener(this._self){
                    private static final long serialVersionUID = 5029554538593371750L;

                    public void val(Object retVal) {
                        __log.debug((Object)("LINKSTATUSINTERCEPTOR: status received " + retVal));
                        LINKSTATUSINTERCEPTOR.this._status = (Boolean)retVal;
                        for (OLink available : LINKSTATUSINTERCEPTOR.this._statuses.keySet()) {
                            SCOPEACT.this._linkFrame.resolve((OLink)available).pub.linkStatus((Boolean)LINKSTATUSINTERCEPTOR.this._statuses.get(available) != false && LINKSTATUSINTERCEPTOR.this._status != false);
                        }
                        if (!LINKSTATUSINTERCEPTOR.this.isDone()) {
                            1.instance(LINKSTATUSINTERCEPTOR.this);
                        }
                    }
                });
            }
            for (final Map.Entry<OLink, LinkInfo> m : this._interceptedChannels.links.entrySet()) {
                if (this._statuses.containsKey(m.getKey())) continue;
                mlset.add(new LinkStatusChannelListener(m.getValue().pub){
                    private static final long serialVersionUID = 1568144473514091593L;

                    public void linkStatus(boolean value) {
                        LINKSTATUSINTERCEPTOR.this._statuses.put(m.getKey(), value);
                        if (LINKSTATUSINTERCEPTOR.this._status != null) {
                            SCOPEACT.this._linkFrame.resolve((OLink)((OLink)m.getKey())).pub.linkStatus(value && LINKSTATUSINTERCEPTOR.this._status != false);
                        }
                        if (!LINKSTATUSINTERCEPTOR.this.isDone()) {
                            2.instance(LINKSTATUSINTERCEPTOR.this);
                        }
                    }
                });
            }
            LINKSTATUSINTERCEPTOR.object(false, mlset);
        }

        private boolean isDone() {
            return this._statuses.keySet().size() < SCOPEACT.this._self.o.outgoingLinks.size();
        }
    }
}

