/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.ACTIVITYGUARD;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.w3c.dom.Element;

public abstract class BpelJacobRunnable
extends JacobRunnable {
    private static final Log __log = LogFactory.getLog(BpelJacobRunnable.class);

    protected BpelRuntimeContext getBpelRuntimeContext() {
        BpelRuntimeContext nativeApi = (BpelRuntimeContext)JacobVPU.activeJacobThread().getExtension(BpelRuntimeContext.class);
        assert (nativeApi != null);
        return nativeApi;
    }

    protected Log log() {
        return __log;
    }

    protected final FaultData createFault(QName fault, Element faultMsg, OVarType faultType, OBase location) {
        return new FaultData(fault, faultMsg, faultType, location);
    }

    protected final FaultData createFault(QName fault, OBase location, String faultExplanation) {
        return new FaultData(fault, location, faultExplanation);
    }

    protected final FaultData createFault(QName fault, OBase location) {
        return this.createFault(fault, location, null);
    }

    protected JacobRunnable createChild(ActivityInfo childInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return new ACTIVITYGUARD(childInfo, scopeFrame, linkFrame);
    }

    protected void initializeCorrelation(CorrelationSetInstance cset, VariableInstance variable) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initializing correlation set " + cset.declaration.name));
        }
        if (this.getBpelRuntimeContext().isCorrelationInitialized(cset)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("OCorrelation set " + cset + " is already set: ignoring"));
            }
            return;
        }
        String[] propNames = new String[cset.declaration.properties.size()];
        String[] propValues = new String[cset.declaration.properties.size()];
        for (int i = 0; i < cset.declaration.properties.size(); ++i) {
            OProcess.OProperty property = cset.declaration.properties.get(i);
            propValues[i] = this.getBpelRuntimeContext().readProperty(variable, property);
            propNames[i] = property.name.toString();
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)("Setting correlation property " + propNames[i] + "=" + propValues[i]));
        }
        CorrelationKey ckeyVal = new CorrelationKey(cset.declaration.name, propValues);
        this.getBpelRuntimeContext().writeCorrelation(cset, ckeyVal);
    }

    protected long genMonotonic() {
        return this.getBpelRuntimeContext().genId();
    }
}

