/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.memdao.CorrelationSetDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.IdGen;
import org.apache.ode.bpel.memdao.PartnerLinkDAOImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.memdao.XmlDataDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeDaoImpl
extends DaoBaseImpl
implements ScopeDAO {
    private String _type;
    private ScopeStateEnum _state;
    private Map<String, XmlDataDAO> _variables = new HashMap<String, XmlDataDAO>();
    private Map<String, CorrelationSetDAO> _correlations = new HashMap<String, CorrelationSetDAO>();
    private Map<Integer, PartnerLinkDAO> _eprs = new HashMap<Integer, PartnerLinkDAO>();
    private ProcessInstanceDaoImpl _processInstance;
    private ScopeDAO _parent;
    private Long _instanceId;
    private int _scopeModelId;

    public ScopeDaoImpl(ProcessInstanceDaoImpl owner, ScopeDAO parent, String type, int scopeModelId) {
        this._processInstance = owner;
        this._parent = parent;
        this._type = type;
        this._instanceId = IdGen.newScopeId();
        this._scopeModelId = scopeModelId;
    }

    @Override
    public CorrelationSetDAO getCorrelationSet(String corrSetName) {
        CorrelationSetDAO corr = this._correlations.get(corrSetName);
        if (corr == null) {
            corr = new CorrelationSetDaoImpl(corrSetName, this);
            this._correlations.put(corrSetName, corr);
        }
        return corr;
    }

    @Override
    public ScopeDAO getParentScope() {
        return this._parent;
    }

    @Override
    public ProcessInstanceDAO getProcessInstance() {
        return this._processInstance;
    }

    @Override
    public void setState(ScopeStateEnum state) {
        this._state = state;
    }

    @Override
    public ScopeStateEnum getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return this._type;
    }

    @Override
    public XmlDataDAO getVariable(String varName) {
        XmlDataDAO v = this._variables.get(varName);
        if (v == null) {
            v = new XmlDataDaoImpl(this, varName);
            this._variables.put(varName, v);
        }
        return v;
    }

    @Override
    public Collection<CorrelationSetDAO> getCorrelationSets() {
        return this._correlations.values();
    }

    @Override
    public Long getScopeInstanceId() {
        return this._instanceId;
    }

    @Override
    public int getModelId() {
        return this._scopeModelId;
    }

    @Override
    public Collection<ScopeDAO> getChildScopes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<XmlDataDAO> getVariables() {
        return this._variables.values();
    }

    @Override
    public List<BpelEvent> listEvents() {
        return new ArrayList<BpelEvent>();
    }

    @Override
    public PartnerLinkDAO createPartnerLink(int plinkModelId, String pLinkName, String myRole, String partnerRole) {
        PartnerLinkDAOImpl eprImpl = new PartnerLinkDAOImpl();
        eprImpl.setPartnerLinkModelId(plinkModelId);
        eprImpl.setPartnerLinkName(pLinkName);
        eprImpl.setMyRoleName(myRole);
        eprImpl.setPartnerRoleName(partnerRole);
        this._eprs.put(plinkModelId, eprImpl);
        return eprImpl;
    }

    @Override
    public PartnerLinkDAO getPartnerLink(int modelId) {
        return this._eprs.get(modelId);
    }

    @Override
    public Collection<PartnerLinkDAO> getPartnerLinks() {
        return this._eprs.values();
    }
}

