/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.AttachmentDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.memdao.MessageExchangeDAOImpl;
import org.apache.ode.bpel.memdao.ProcessDaoImpl;
import org.apache.ode.bpel.memdao.ProcessManagementDaoImpl;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelDAOConnectionImpl
implements BpelDAOConnection {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionImpl.class);
    private Scheduler _scheduler;
    private Map<QName, ProcessDaoImpl> _store;
    private List<BpelEvent> _events = new LinkedList<BpelEvent>();
    long _mexTtl;
    private static Map<String, MessageExchangeDAO> _mexStore = Collections.synchronizedMap(new HashMap());
    protected static Map<String, Long> _mexAge = new ConcurrentHashMap<String, Long>();
    private static AtomicLong counter = new AtomicLong(0x3FFFFFFFFFFFFFFFL);
    private static volatile long _lastRemoval = 0L;

    BpelDAOConnectionImpl(Map<QName, ProcessDaoImpl> store, Scheduler scheduler, long mexTtl) {
        this._store = store;
        this._scheduler = scheduler;
        this._mexTtl = mexTtl;
    }

    @Override
    public ProcessDAO getProcess(QName processId) {
        return this._store.get(processId);
    }

    @Override
    public ProcessDAO createTransientProcess(Long id) {
        ProcessDaoImpl process = new ProcessDaoImpl(this, this._store, null, null, null, 0L);
        return process;
    }

    @Override
    public ProcessDAO createProcess(QName pid, QName type, String guid, long version) {
        ProcessDaoImpl process = new ProcessDaoImpl(this, this._store, pid, type, guid, version);
        this._store.put(pid, process);
        return process;
    }

    @Override
    public ProcessInstanceDAO getInstance(Long iid) {
        for (ProcessDaoImpl proc : this._store.values()) {
            ProcessInstanceDAO instance = proc._instances.get(iid);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public int getNumInstances(QName processId) {
        ProcessDAO process = this.getProcess(processId);
        if (process != null) {
            return process.getNumInstances();
        }
        return -1;
    }

    @Override
    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter filter) {
        if (filter.getLimit() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProcessInstanceDAO> matched = new ArrayList<ProcessInstanceDAO>();
        block0: for (ProcessDaoImpl proc : this._store.values()) {
            boolean pmatch = true;
            if (filter.getNameFilter() != null && !this.equalsOrWildcardMatch(filter.getNameFilter(), proc.getProcessId().getLocalPart())) {
                pmatch = false;
            }
            if (filter.getNamespaceFilter() != null && !this.equalsOrWildcardMatch(filter.getNamespaceFilter(), proc.getProcessId().getNamespaceURI())) {
                pmatch = false;
            }
            if (!pmatch) continue;
            for (ProcessInstanceDAO inst : proc._instances.values()) {
                boolean match = true;
                if (filter.getStatusFilter() != null) {
                    boolean statusMatch = false;
                    for (Short status : filter.convertFilterState()) {
                        if (inst.getState() != status.byteValue()) continue;
                        statusMatch = true;
                    }
                    if (!statusMatch) {
                        match = false;
                    }
                }
                if (filter.getStartedDateFilter() != null && !this.dateMatch(filter.getStartedDateFilter(), inst.getCreateTime(), filter)) {
                    match = false;
                }
                if (filter.getLastActiveDateFilter() != null && !this.dateMatch(filter.getLastActiveDateFilter(), inst.getLastActiveTime(), filter)) {
                    match = false;
                }
                if (!match) continue;
                matched.add(inst);
                if (matched.size() != filter.getLimit()) continue;
                break block0;
            }
        }
        if (filter.getOrders() != null) {
            final List<String> orders = filter.getOrders();
            Collections.sort(matched, new Comparator<ProcessInstanceDAO>(){

                @Override
                public int compare(ProcessInstanceDAO o1, ProcessInstanceDAO o2) {
                    for (String orderKey : orders) {
                        int result = BpelDAOConnectionImpl.this.compareInstanceUsingKey(orderKey, o1, o2);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            });
        }
        return matched;
    }

    @Override
    public void close() {
    }

    public Collection<ProcessDAO> processQuery(ProcessFilter filter) {
        throw new UnsupportedOperationException("Can't query process configuration using a transient DAO.");
    }

    @Override
    public MessageExchangeDAO createMessageExchange(char dir) {
        final String id = Long.toString(counter.getAndIncrement());
        MessageExchangeDAOImpl mex = new MessageExchangeDAOImpl(dir, id);
        long now = System.currentTimeMillis();
        _mexStore.put(id, mex);
        _mexAge.put(id, now);
        if (now > _lastRemoval + this._mexTtl / 10L) {
            _lastRemoval = now;
            Object[] oldMexs = _mexAge.keySet().toArray();
            for (int i = oldMexs.length - 1; i > 0; --i) {
                String oldMex = (String)oldMexs[i];
                Long age = _mexAge.get(oldMex);
                if (age == null || now - age <= this._mexTtl) continue;
                BpelDAOConnectionImpl.removeMessageExchange(oldMex);
                _mexAge.remove(oldMex);
            }
        }
        this.onRollback(new Runnable(){

            public void run() {
                BpelDAOConnectionImpl.removeMessageExchange(id);
                _mexAge.remove(id);
            }
        });
        return mex;
    }

    @Override
    public MessageExchangeDAO getMessageExchange(String mexid) {
        return _mexStore.get(mexid);
    }

    private int compareInstanceUsingKey(String key, ProcessInstanceDAO instanceDAO1, ProcessInstanceDAO instanceDAO2) {
        String s1 = null;
        String s2 = null;
        boolean ascending = true;
        String orderKey = key;
        if (key.startsWith("+") || key.startsWith("-")) {
            orderKey = key.substring(1, key.length());
            if (key.startsWith("-")) {
                ascending = false;
            }
        }
        ProcessDAO process1 = this.getProcess(instanceDAO1.getProcess().getProcessId());
        ProcessDAO process2 = this.getProcess(instanceDAO2.getProcess().getProcessId());
        if ("pid".equals(orderKey)) {
            s1 = process1.getProcessId().toString();
            s2 = process2.getProcessId().toString();
        } else if ("name".equals(orderKey)) {
            s1 = process1.getProcessId().getLocalPart();
            s2 = process2.getProcessId().getLocalPart();
        } else if ("namespace".equals(orderKey)) {
            s1 = process1.getProcessId().getNamespaceURI();
            s2 = process2.getProcessId().getNamespaceURI();
        } else if ("version".equals(orderKey)) {
            s1 = "" + process1.getVersion();
            s2 = "" + process2.getVersion();
        } else if ("status".equals(orderKey)) {
            s1 = "" + instanceDAO1.getState();
            s2 = "" + instanceDAO2.getState();
        } else if ("started".equals(orderKey)) {
            s1 = ISO8601DateParser.format(instanceDAO1.getCreateTime());
            s2 = ISO8601DateParser.format(instanceDAO2.getCreateTime());
        } else if ("last-active".equals(orderKey)) {
            s1 = ISO8601DateParser.format(instanceDAO1.getLastActiveTime());
            s2 = ISO8601DateParser.format(instanceDAO2.getLastActiveTime());
        }
        if (ascending) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private boolean equalsOrWildcardMatch(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.equals(s2)) {
            return true;
        }
        if (s1.endsWith("*") && s2.startsWith(s1.substring(0, s1.length() - 1))) {
            return true;
        }
        return s2.endsWith("*") && s1.startsWith(s2.substring(0, s2.length() - 1));
    }

    public boolean dateMatch(List<String> dateFilters, Date instanceDate, InstanceFilter filter) {
        boolean match = true;
        for (String ddf : dateFilters) {
            String isoDate = ISO8601DateParser.format(instanceDate);
            String critDate = Filter.getDateWithoutOp(ddf);
            if (ddf.startsWith("=")) {
                if (isoDate.startsWith(critDate)) continue;
                match = false;
                continue;
            }
            if (ddf.startsWith("<=")) {
                if (isoDate.startsWith(critDate) || isoDate.compareTo(critDate) <= 0) continue;
                match = false;
                continue;
            }
            if (ddf.startsWith(">=")) {
                if (isoDate.startsWith(critDate) || isoDate.compareTo(critDate) >= 0) continue;
                match = false;
                continue;
            }
            if (ddf.startsWith("<")) {
                if (isoDate.compareTo(critDate) <= 0) continue;
                match = false;
                continue;
            }
            if (!ddf.startsWith(">") || isoDate.compareTo(critDate) >= 0) continue;
            match = false;
        }
        return match;
    }

    @Override
    public ScopeDAO getScope(Long siidl) {
        for (ProcessDaoImpl process : this._store.values()) {
            for (ProcessInstanceDAO instance : process._instances.values()) {
                if (instance.getScope(siidl) == null) continue;
                return instance.getScope(siidl);
            }
        }
        return null;
    }

    @Override
    public void insertBpelEvent(BpelEvent event, ProcessDAO processConfiguration, ProcessInstanceDAO instance) {
        this._events.add(event);
    }

    @Override
    public List<Date> bpelEventTimelineQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        ArrayList<Date> dates = new ArrayList<Date>();
        CollectionsX.transform(dates, this._events, new UnaryFunction<BpelEvent, Date>(){

            @Override
            public Date apply(BpelEvent x) {
                return x.getTimestamp();
            }
        });
        return dates;
    }

    @Override
    public List<BpelEvent> bpelEventQuery(InstanceFilter ifilter, BpelEventFilter efilter) {
        return this._events;
    }

    @Override
    public Collection<ProcessInstanceDAO> instanceQuery(String expression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long instanceCount(InstanceFilter criteria) {
        throw new UnsupportedOperationException();
    }

    static void removeMessageExchange(String mexId) {
        MessageExchangeDAO mex;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Removing mex " + mexId + " from memory store."));
        }
        if ((mex = _mexStore.remove(mexId)) == null) {
            __log.warn((Object)("Couldn't find mex " + mexId + " for cleanup."));
        }
        _mexAge.remove(mexId);
    }

    public void defer(final Runnable runnable) {
        this._scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean success) {
            }

            public void beforeCompletion() {
                runnable.run();
            }
        });
    }

    public void onRollback(final Runnable runnable) {
        this._scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean success) {
                if (!success) {
                    runnable.run();
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    public Map<Long, Collection<CorrelationSetDAO>> getCorrelationSets(Collection<ProcessInstanceDAO> instances) {
        HashMap<Long, Collection<CorrelationSetDAO>> map = new HashMap<Long, Collection<CorrelationSetDAO>>();
        for (ProcessInstanceDAO instance : instances) {
            Long id = instance.getInstanceId();
            ArrayList<CorrelationSetDAO> existing = (ArrayList<CorrelationSetDAO>)map.get(id);
            if (existing == null) {
                existing = new ArrayList<CorrelationSetDAO>();
                map.put(id, existing);
            }
            existing.addAll(instance.getCorrelationSets());
        }
        return map;
    }

    @Override
    public Collection<CorrelationSetDAO> getActiveCorrelationSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcessManagementDaoImpl getProcessManagement() {
        return new ProcessManagementDaoImpl();
    }

    @Override
    public AttachmentDAO getAttachmentDAO(Long attachmentID, MessageExchangeDAO mex) {
        String message = "Method is not implemented.";
        UnsupportedOperationException ex = new UnsupportedOperationException(message);
        __log.warn((Object)message, (Throwable)ex);
        throw ex;
    }
}

