/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDL20Endpoint
implements MutableEndpoint {
    private Element _serviceElmt;

    public String getSessionId() {
        Element endpointElmt = (Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_20, "endpoint").item(0);
        NodeList idNodes = endpointElmt.getElementsByTagNameNS(Namespaces.ODE_SESSION_NS, "session");
        if (idNodes.getLength() > 0) {
            return idNodes.item(0).getTextContent();
        }
        idNodes = endpointElmt.getElementsByTagNameNS(Namespaces.INTALIO_SESSION_NS, "session");
        if (idNodes.getLength() > 0) {
            return idNodes.item(0).getTextContent();
        }
        return null;
    }

    public void setSessionId(String sessionId) {
        Element sessElmt;
        Element endpointElmt = (Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_20, "endpoint").item(0);
        NodeList idList = endpointElmt.getElementsByTagNameNS(Namespaces.ODE_SESSION_NS, "session");
        if (idList.getLength() > 0) {
            idList.item(0).setTextContent(sessionId);
        } else {
            sessElmt = endpointElmt.getOwnerDocument().createElementNS(Namespaces.ODE_SESSION_NS, "session");
            sessElmt.setTextContent(sessionId);
            endpointElmt.appendChild(sessElmt);
        }
        idList = endpointElmt.getElementsByTagNameNS(Namespaces.INTALIO_SESSION_NS, "session");
        if (idList.getLength() > 0) {
            idList.item(0).setTextContent(sessionId);
        } else {
            sessElmt = endpointElmt.getOwnerDocument().createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
            sessElmt.setTextContent(sessionId);
            endpointElmt.appendChild(sessElmt);
        }
    }

    public String getUrl() {
        return ((Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_20, "endpoint").item(0)).getAttribute("address");
    }

    public void setUrl(String url) {
        Element endpointElmt = (Element)this._serviceElmt.getElementsByTagNameNS(Namespaces.WSDL_20, "endpoint").item(0);
        NodeList addrList = endpointElmt.getElementsByTagNameNS(Namespaces.WSDL_20, "address");
        if (addrList.getLength() > 0) {
            addrList.item(0).setTextContent(url);
        } else {
            Element addrElmt = this._serviceElmt.getOwnerDocument().createElementNS(Namespaces.WSDL_20, "address");
            addrElmt.setTextContent(url);
            endpointElmt.appendChild(addrElmt);
        }
    }

    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element elmt = (Element)node;
            if (elmt.getLocalName().equals("service-ref") && (elmt.getNamespaceURI().equals(Namespaces.WS_BPEL_20_NS) || elmt.getNamespaceURI().equals(Namespaces.WSBPEL2_0_FINAL_SERVREF))) {
                elmt = DOMUtils.getFirstChildElement(elmt);
            }
            if (elmt.getLocalName().equals("service") && elmt.getNamespaceURI().equals(Namespaces.WSDL_20)) {
                return true;
            }
        }
        return false;
    }

    public void set(Node node) {
        this._serviceElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)node) : (Element)node;
    }

    public Document toXML() {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(Namespaces.WSBPEL2_0_FINAL_SERVREF, "service-ref");
        doc.appendChild(serviceRef);
        serviceRef.appendChild(doc.importNode(this._serviceElmt, true));
        return doc;
    }

    public Map toMap() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("address", this.getUrl());
        String sid = this.getSessionId();
        if (sid != null) {
            result.put("session", sid);
        }
        return result;
    }

    public void fromMap(Map eprMap) {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        this._serviceElmt = doc.createElementNS(Namespaces.WSDL_20, "service");
        this._serviceElmt.setAttribute("name", "");
        this._serviceElmt.setAttribute("interface", "");
        serviceRef.appendChild(this._serviceElmt);
        Element endpoint = doc.createElementNS(Namespaces.WSDL_20, "endpoint");
        endpoint.setAttribute("name", "");
        endpoint.setAttribute("binding", "");
        if (eprMap.get("address") != null) {
            endpoint.setAttribute("address", (String)eprMap.get("address"));
        }
        if (eprMap.get("session") != null) {
            Element session = doc.createElementNS(Namespaces.ODE_SESSION_NS, "session");
            session.setTextContent((String)eprMap.get("session"));
            endpoint.appendChild(session);
            session = doc.createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
            session.setTextContent((String)eprMap.get("session"));
            endpoint.appendChild(session);
        }
        this._serviceElmt.appendChild(endpoint);
        doc.appendChild(this._serviceElmt);
    }
}

