/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.wsdl.OperationType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.utils.ObjectPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMAManager
implements Serializable {
    private static final long serialVersionUID = -5556374398943757951L;
    private static final Log __log = LogFactory.getLog(IMAManager.class);
    public final Map<RequestIdTuple, Entry> _byRid = new HashMap<RequestIdTuple, Entry>();
    public final Map<OutstandingRequestIdTuple, String> _byOrid = new HashMap<OutstandingRequestIdTuple, String>();
    public final Map<String, Entry> _byChannel = new HashMap<String, Entry>();

    int findConflict(Selector[] selectors) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("findConflict", new Object[]{"selectors", selectors}));
        }
        HashSet<RequestIdTuple> workingSet = new HashSet<RequestIdTuple>(this._byRid.keySet());
        for (int i = 0; i < selectors.length; ++i) {
            RequestIdTuple rid = new RequestIdTuple(selectors[i].plinkInstance, selectors[i].opName);
            if (workingSet.contains(rid)) {
                return i;
            }
            workingSet.add(rid);
        }
        return -1;
    }

    void register(String pickResponseChannel, Selector[] selectors) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("register", new Object[]{"pickResponseChannel", pickResponseChannel, "selectors", selectors}));
        }
        if (this._byChannel.containsKey(pickResponseChannel)) {
            String errmsg = "INTERNAL ERROR: Duplicate ENTRY for RESPONSE CHANNEL " + pickResponseChannel;
            __log.fatal((Object)errmsg);
            throw new IllegalArgumentException(errmsg);
        }
        Entry entry = new Entry(pickResponseChannel, selectors);
        for (int i = 0; i < selectors.length; ++i) {
            RequestIdTuple rid = new RequestIdTuple(selectors[i].plinkInstance, selectors[i].opName);
            if (this._byRid.containsKey(rid)) {
                String errmsg = "INTERNAL ERROR: Duplicate ENTRY for RID " + rid;
                __log.fatal((Object)errmsg);
                throw new IllegalStateException(errmsg);
            }
            this._byRid.put(rid, entry);
        }
        this._byChannel.put(pickResponseChannel, entry);
    }

    String processOutstandingRequest(PartnerLinkInstance partnerLink, String opName, String mexId, String mexRef) {
        OutstandingRequestIdTuple orid;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("process", new Object[]{"partnerLinkInstance", partnerLink, "operationName", opName, "messageExchangeId", mexId, "mexRef", mexRef}));
        }
        if (this._byOrid.containsKey(orid = new OutstandingRequestIdTuple(partnerLink, opName, mexId))) {
            return mexRef;
        }
        if (partnerLink.partnerLink.getMyRoleOperation(opName).getStyle().equals(OperationType.REQUEST_RESPONSE)) {
            this._byOrid.put(orid, mexRef);
        }
        return null;
    }

    void cancel(String pickResponseChannel, boolean isTimer) {
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("cancel", new Object[]{"pickResponseChannel", pickResponseChannel}));
        }
        if ((entry = this._byChannel.remove(pickResponseChannel)) != null) {
            while (this._byRid.values().remove(entry)) {
            }
        } else if (!isTimer) {
            String errmsg = "INTERNAL ERROR: No ENTRY for RESPONSE CHANNEL " + pickResponseChannel;
            __log.fatal((Object)errmsg);
            throw new IllegalArgumentException(errmsg);
        }
    }

    public String release(PartnerLinkInstance plinkInstnace, String opName, String mexId) {
        OutstandingRequestIdTuple orid;
        String mexRef;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("release", new Object[]{"plinkInstance", plinkInstnace, "opName", opName, "mexId", mexId}));
        }
        if ((mexRef = this._byOrid.remove(orid = new OutstandingRequestIdTuple(plinkInstnace, opName, mexId))) == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("==release: ORID " + orid + " not found in " + this._byOrid));
            }
            return null;
        }
        return mexRef;
    }

    public void migrateRids(Map<OutstandingRequestManager.RequestIdTuple, OutstandingRequestManager.Entry> oldRids) {
        for (OutstandingRequestManager.RequestIdTuple oldRid : oldRids.keySet()) {
            OutstandingRequestManager.Entry oldEntry = oldRids.get(oldRid);
            if (oldEntry.mexRef != null) {
                OutstandingRequestIdTuple orid = new OutstandingRequestIdTuple(oldRid.partnerLink, oldRid.opName, oldRid.mexId);
                this._byOrid.put(orid, oldEntry.mexRef);
                continue;
            }
            RequestIdTuple rid = new RequestIdTuple(oldRid.partnerLink, oldRid.opName);
            Entry entry = new Entry(oldEntry.pickResponseChannel, (Selector[])oldEntry.selectors);
            this._byRid.put(rid, entry);
            this._byChannel.put(entry.pickResponseChannel, entry);
        }
    }

    public String[] releaseAll() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter("releaseAll", null));
        }
        ArrayList<String> mexRefs = new ArrayList<String>();
        while (!this._byOrid.isEmpty()) {
            String mexRef = this._byOrid.entrySet().iterator().next().getValue();
            mexRefs.add(mexRef);
            this._byOrid.values().remove(mexRef);
        }
        return mexRefs.toArray(new String[mexRefs.size()]);
    }

    public String toString() {
        return ObjectPrinter.toString(this, new Object[]{"byRid", this._byRid, "byOrid", this._byOrid, "byChannel", this._byChannel});
    }

    public class Entry
    implements Serializable {
        private static final long serialVersionUID = -583743124656582887L;
        final String pickResponseChannel;
        public Selector[] selectors;

        private Entry(String pickResponseChannel, Selector[] selectors) {
            this.pickResponseChannel = pickResponseChannel;
            this.selectors = selectors;
        }

        public String toString() {
            return ObjectPrinter.toString(this, new Object[]{"pickResponseChannel", this.pickResponseChannel, "selectors", this.selectors});
        }
    }

    private class OutstandingRequestIdTuple
    implements Serializable {
        private static final long serialVersionUID = -1059389611839777482L;
        PartnerLinkInstance partnerLink;
        String opName;
        String mexId;

        private OutstandingRequestIdTuple(PartnerLinkInstance partnerLink, String opName, String mexId) {
            this.partnerLink = partnerLink;
            this.opName = opName;
            this.mexId = mexId == null ? "" : mexId;
        }

        public int hashCode() {
            return this.partnerLink.hashCode() ^ this.opName.hashCode() ^ this.mexId.hashCode();
        }

        public boolean equals(Object obj) {
            OutstandingRequestIdTuple other = (OutstandingRequestIdTuple)obj;
            return other.partnerLink.equals(this.partnerLink) && other.opName.equals(this.opName) && other.mexId.equals(this.mexId);
        }

        public String toString() {
            return ObjectPrinter.toString(this, new Object[]{"partnerLink", this.partnerLink, "opName", this.opName, "mexId", this.mexId});
        }
    }

    private class RequestIdTuple
    implements Serializable {
        private static final long serialVersionUID = -1059389611839777482L;
        PartnerLinkInstance partnerLink;
        String opName;

        private RequestIdTuple(PartnerLinkInstance partnerLink, String opName) {
            this.partnerLink = partnerLink;
            this.opName = opName;
        }

        public int hashCode() {
            return this.partnerLink.hashCode() ^ this.opName.hashCode();
        }

        public boolean equals(Object obj) {
            RequestIdTuple other = (RequestIdTuple)obj;
            return other.partnerLink.equals(this.partnerLink) && other.opName.equals(this.opName);
        }

        public String toString() {
            return ObjectPrinter.toString(this, new Object[]{"partnerLink", this.partnerLink, "opName", this.opName});
        }
    }
}

