/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.List;
import java.util.concurrent.Future;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredMyRoleMessageExchangeImpl
extends MyRoleMessageExchangeImpl {
    private List<MyRoleMessageExchange> subscribers;
    private MyRoleMessageExchange template;

    public BrokeredMyRoleMessageExchangeImpl(BpelProcess process, BpelEngineImpl engine, List<MyRoleMessageExchange> subscribers, MessageExchangeDAO mexDao, MyRoleMessageExchange template) {
        super(process, engine, mexDao);
        this.subscribers = subscribers;
        this.template = template;
    }

    @Override
    public Future invoke(Message request) {
        Future myFuture = null;
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            BpelProcess process = ((MyRoleMessageExchangeImpl)subscriber)._process;
            if (process.getConf().getState() != ProcessState.ACTIVE) continue;
            Future theirFuture = subscriber.invoke(request);
            if (myFuture != null) continue;
            myFuture = theirFuture;
        }
        return myFuture;
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        return this.template.getEndpointReference();
    }

    @Override
    public Message getResponse() {
        return this.template.getResponse();
    }

    @Override
    public MessageExchange.Status getStatus() {
        return this.template.getStatus();
    }

    @Override
    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return this.template.getCorrelationStatus();
    }

    @Override
    public int getSubscriberCount() {
        return this.subscribers != null ? this.subscribers.size() : 0;
    }

    @Override
    public void setSubscriberCount(int subscriberCount) {
        for (MyRoleMessageExchange subscriber : this.subscribers) {
            ((MyRoleMessageExchangeImpl)subscriber).setSubscriberCount(subscriberCount);
        }
    }

    @Override
    public PortType getPortType() {
        return this.template.getPortType();
    }

    @Override
    public Operation getOperation() {
        return this.template.getOperation();
    }
}

