/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.runtime.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.runtime.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.runtime.XPath20ExpressionModifier;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.explang.ExpressionLanguageRuntime;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPath20ExpressionRuntime
implements ExpressionLanguageRuntime {
    static final short NODE_TYPE = 1;
    static final short NODESET_TYPE = 2;
    static final short STRING_TYPE = 3;
    static final short BOOLEAN_TYPE = 4;
    static final short NUMBER_TYPE = 5;
    private static final Log __log = LogFactory.getLog(XPath20ExpressionRuntime.class);
    private final XPathFactory _xpf = new XPathFactoryImpl();

    public void initialize(Map properties) throws ConfigurationException {
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (String)this.evaluate(cexp, ctx, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (Boolean)this.evaluate(cexp, ctx, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (Number)this.evaluate(cexp, ctx, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        List<Object> result;
        Object someRes = null;
        try {
            someRes = this.evaluate(cexp, ctx, XPathConstants.NODESET);
        }
        catch (Exception e) {
            someRes = this.evaluate(cexp, ctx, XPathConstants.STRING);
        }
        if (someRes instanceof List) {
            result = (ArrayList)someRes;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Returned list of size " + result.size()));
            }
            if (result.size() == 1 && !(result.get(0) instanceof Node)) {
                Object simpleType = result.get(0);
                String textVal = simpleType instanceof Date ? ISO8601DateParser.format((Date)simpleType) : (simpleType instanceof DurationValue ? ((DurationValue)simpleType).getStringValue() : simpleType.toString());
                Document document = DOMUtils.newDocument();
                Element wrapper = document.createElement("wrapper");
                Text text = document.createTextNode(textVal);
                wrapper.appendChild(text);
                document.appendChild(wrapper);
                result = Collections.singletonList(text);
            }
        } else if (someRes instanceof NodeList) {
            NodeList retVal = (NodeList)someRes;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Returned node list of size " + retVal.getLength()));
            }
            result = new ArrayList(retVal.getLength());
            for (int m = 0; m < retVal.getLength(); ++m) {
                Node val = retVal.item(m);
                if (val.getNodeType() == 9) {
                    val = ((Document)val).getDocumentElement();
                }
                result.add(val);
            }
        } else if (someRes instanceof String) {
            Document document = DOMUtils.newDocument();
            Element wrapper = document.createElement("wrapper");
            Text text = document.createTextNode((String)someRes);
            wrapper.appendChild(text);
            document.appendChild(wrapper);
            result = Collections.singletonList(text);
        } else {
            result = null;
        }
        return result;
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        List retVal = this.evaluate(cexp, ctx);
        if (retVal.size() == 0 || retVal.size() > 1) {
            StringBuffer msg = new StringBuffer(retVal.size() == 0 ? "No results for expression: '" : "Multiple results for expression: '");
            if (cexp instanceof OXPath10Expression) {
                msg.append(((OXPath10Expression)cexp).xpath);
            } else {
                msg.append(cexp.toString());
            }
            msg.append('\'');
            if (ctx.getRootNode() != null) {
                msg.append(" against '");
                msg.append(DOMUtils.domToString(ctx.getRootNode()));
                msg.append('\'');
            }
            if (retVal.size() == 0) {
                throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, msg.toString(), new Throwable("ignoreMissingFromData"));
            }
            if (retVal.size() > 1) {
                throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, msg.toString());
            }
        }
        return (Node)retVal.get(0);
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        List<Node> literal = DOMUtils.toList(this.evaluate(cexp, context));
        if (literal.size() == 0) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "No results for expression: " + cexp);
        }
        if (literal.size() > 1) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + cexp);
        }
        Object date = literal.get(0);
        if (date instanceof Calendar) {
            return (Calendar)date;
        }
        if (date instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)date);
            return cal;
        }
        if (date instanceof Element) {
            date = ((Element)date).getTextContent();
        }
        if (date instanceof Text) {
            date = ((Text)date).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal(date.toString());
        }
        catch (Exception ex) {
            String errmsg = "Invalid date: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        String literal = this.evaluateAsString(cexp, context);
        try {
            return new Duration(literal);
        }
        catch (Exception ex) {
            String errmsg = "Invalid duration: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    private Object evaluate(OExpression cexp, EvaluationContext ctx, QName type) throws FaultException, EvaluationException {
        try {
            Object evalResult;
            OXPath20ExpressionBPEL20 oxpath20 = (OXPath20ExpressionBPEL20)cexp;
            JaxpFunctionResolver funcResolver = new JaxpFunctionResolver(ctx, oxpath20);
            JaxpVariableResolver varResolver = new JaxpVariableResolver(ctx, oxpath20, ((XPathFactoryImpl)this._xpf).getConfiguration());
            XPath xpe = this._xpf.newXPath();
            xpe.setXPathFunctionResolver(funcResolver);
            xpe.setXPathVariableResolver(varResolver);
            xpe.setNamespaceContext(oxpath20.namespaceCtx);
            String xpath = ((OXPath10Expression)cexp).xpath;
            XPathExpression expr = xpe.compile(xpath);
            Node contextNode = ctx.getRootNode();
            if (contextNode == null) {
                contextNode = DOMUtils.newDocument();
            }
            if (oxpath20.insertMissingData) {
                XPath20ExpressionModifier modifier = new XPath20ExpressionModifier(oxpath20.namespaceCtx, ((XPathFactoryImpl)this._xpf).getConfiguration().getNamePool());
                modifier.insertMissingData(expr, ctx.getRootNode());
            }
            if ((evalResult = expr.evaluate(contextNode, type)) != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + cexp.toString() + " generated result " + evalResult + " - type=" + evalResult.getClass().getName()));
                if (ctx.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString(ctx.getRootNode())));
                }
            }
            return evalResult;
        }
        catch (XPathExpressionException e) {
            Throwable th;
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof XPathException && (th = ((XPathException)cause).getException()) != null && (cause = th).getCause() != null) {
                cause = cause.getCause();
            }
            throw new EvaluationException("Error while executing an XPath expression: " + cause.toString(), cause);
        }
        catch (WrappedResolverException wre) {
            __log.debug((Object)"Could not evaluate expression because of ", (Throwable)wre);
            throw (FaultException)wre.getCause();
        }
        catch (Throwable t) {
            __log.debug((Object)"Could not evaluate expression because of ", t);
            throw new EvaluationException("Error while executing an XPath expression: ", t);
        }
    }
}

