/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import java.util.Collections;
import java.util.List;
import org.apache.ode.bpel.compiler.bom.Bpel20QNames;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.compiler.bom.CompensationHandler;
import org.apache.ode.bpel.compiler.bom.CorrelationSet;
import org.apache.ode.bpel.compiler.bom.CorrelationSets;
import org.apache.ode.bpel.compiler.bom.FaultHandler;
import org.apache.ode.bpel.compiler.bom.JoinFailureSuppressor;
import org.apache.ode.bpel.compiler.bom.OnAlarm;
import org.apache.ode.bpel.compiler.bom.OnEvent;
import org.apache.ode.bpel.compiler.bom.PartnerLink;
import org.apache.ode.bpel.compiler.bom.PartnerLinks;
import org.apache.ode.bpel.compiler.bom.TerminationHandler;
import org.apache.ode.bpel.compiler.bom.Variable;
import org.apache.ode.bpel.compiler.bom.Variables;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope
extends JoinFailureSuppressor {
    public Scope(Element el) {
        super(el);
    }

    public CompensationHandler getCompensationHandler() {
        return this.getFirstChild(CompensationHandler.class);
    }

    public TerminationHandler getTerminationHandler() {
        return this.getFirstChild(TerminationHandler.class);
    }

    public FaultHandler getFaultHandler() {
        return this.getFirstChild(FaultHandler.class);
    }

    public List<CorrelationSet> getCorrelationSetDecls() {
        CorrelationSets csets = this.getFirstChild(CorrelationSets.class);
        if (csets == null) {
            return Collections.emptyList();
        }
        return csets.getChildren(CorrelationSet.class);
    }

    public CorrelationSet getCorrelationSetDecl(final String setName) {
        return CollectionsX.find_if(this.getCorrelationSetDecls(), new MemberOfFunction<CorrelationSet>(){

            @Override
            public boolean isMember(CorrelationSet cs) {
                return setName.equals(cs.getName());
            }
        });
    }

    public Variable getVariableDecl(final String varName) {
        return CollectionsX.find_if(this.getVariables(), new MemberOfFunction<Variable>(){

            @Override
            public boolean isMember(Variable v) {
                return varName.equals(v.getName());
            }
        });
    }

    public List<Variable> getVariables() {
        Variables vars = this.getFirstChild(Variables.class);
        if (vars == null) {
            return Collections.emptyList();
        }
        return vars.getChildren(Variable.class);
    }

    public List<OnAlarm> getAlarms() {
        BpelObject eventHandlers = this.getFirstChild(this.rewriteTargetNS(Bpel20QNames.EVENTHANDLERS));
        if (eventHandlers == null) {
            return Collections.emptyList();
        }
        return eventHandlers.getChildren(OnAlarm.class);
    }

    public List<OnEvent> getEvents() {
        BpelObject eventHandlers = this.getFirstChild(this.rewriteTargetNS(Bpel20QNames.EVENTHANDLERS));
        if (eventHandlers == null) {
            return Collections.emptyList();
        }
        return eventHandlers.getChildren(OnEvent.class);
    }

    public boolean isVariableAccessSerialized() {
        return false;
    }

    public Boolean getAtomicScope() {
        String value = this.getAttribute("atomic", null);
        if ("yes".equals(value)) {
            return Boolean.TRUE;
        }
        if ("no".equals(value)) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean getIsolatedScope() {
        String value = this.getAttribute("isolated", "no");
        if ("yes".equals(value)) {
            return Boolean.TRUE;
        }
        if ("no".equals(value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public PartnerLink getPartnerLink(final String partnerLinkName) {
        return CollectionsX.find_if(this.getPartnerLinks(), new MemberOfFunction<PartnerLink>(){

            @Override
            public boolean isMember(PartnerLink pl) {
                return partnerLinkName.equals(pl.getName());
            }
        });
    }

    public List<PartnerLink> getPartnerLinks() {
        PartnerLinks plinks = this.getFirstChild(PartnerLinks.class);
        if (plinks == null) {
            return Collections.emptyList();
        }
        return plinks.getChildren(PartnerLink.class);
    }
}

