/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.api;

import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.utils.msg.MessageBundle;

public abstract class CompilationMessageBundle
extends MessageBundle {
    private static String[] PREFIXES = new String[]{"inf", "warn", "err"};
    private static short[] SEVERITIES = new short[]{0, 1, 2};

    protected CompilationMessage formatCompilationMessage(String message, Object ... args) {
        int i;
        String methodName = "errUnknown";
        String methodKey = null;
        short severity = 0;
        String msg = this.format(message, args);
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack.length > 1) {
            methodName = stack[1].getMethodName();
        }
        for (i = 0; i < PREFIXES.length; ++i) {
            if (!methodName.startsWith(PREFIXES[i])) continue;
            methodKey = methodName.substring(PREFIXES[i].length());
            severity = SEVERITIES[i];
            break;
        }
        if (methodKey == null) {
            if (stack.length > 2) {
                methodName = stack[2].getMethodName();
            }
            for (i = 0; i < PREFIXES.length; ++i) {
                if (!methodName.startsWith(PREFIXES[i])) continue;
                methodKey = methodName.substring(PREFIXES[i].length());
                severity = SEVERITIES[i];
                break;
            }
            if (methodKey == null) {
                throw new UnsupportedOperationException("unexpected caller method: " + methodName);
            }
        }
        CompilationMessage cmsg = new CompilationMessage();
        cmsg.severity = severity;
        cmsg.phase = 0;
        cmsg.messageText = msg;
        cmsg.code = methodKey;
        return cmsg;
    }
}

