/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionValidator;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.o.OVarType;

public class ExpressionValidatorFactory {
    private static final Log __log = LogFactory.getLog(ExpressionValidatorFactory.class);
    private ExpressionValidator _validator = new EmptyValidator();

    public ExpressionValidatorFactory(Properties config) {
        String propertyName = "org.apache.ode.validator";
        String validatorClass = config.getProperty(propertyName, "");
        __log.debug((Object)("Trying property " + propertyName + " got value: " + validatorClass));
        if (!validatorClass.equals("")) {
            try {
                this.getClass();
                this._validator = (ExpressionValidator)Class.forName(validatorClass).newInstance();
            }
            catch (Exception e) {
                __log.warn((Object)("Cannot instantiate expression validator of class " + validatorClass));
            }
        }
    }

    public ExpressionValidator getValidator() {
        return this._validator;
    }

    private static class EmptyValidator
    implements ExpressionValidator {
        private EmptyValidator() {
        }

        public void bpelImportsLoaded(Process source, CompilerContext compilerContext) throws CompilationException {
        }

        public void bpelCompilationCompleted(Process source) throws CompilationException {
        }

        public Object validate(Expression source, OVarType rootNodeType, Object requestedResultType) throws CompilationException {
            return null;
        }
    }
}

