/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ode.bpel.common.Messages;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter<FKEY extends Enum>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    protected static final Messages __msgs = MessageBundle.getMessages(Messages.class);
    public static final Pattern __comparatorPattern = Pattern.compile("([^=<> ]*) *(<>|<=|>=|<|>|=) *([^=<> ]*)");
    protected Map<FKEY, Restriction<String>> _criteria = new HashMap<FKEY, Restriction<String>>();

    public void init(String filter) {
        if (filter != null) {
            Matcher expressionMatcher = __comparatorPattern.matcher(filter);
            while (expressionMatcher.find()) {
                FKEY keyval;
                String filterKey = expressionMatcher.group(1);
                String op = expressionMatcher.group(2);
                String value = expressionMatcher.group(3);
                try {
                    keyval = this.parseKey(filterKey.toUpperCase().replaceAll("-", "_"));
                }
                catch (Exception ex) {
                    String errmsg = __msgs.msgUnrecognizedFilterKey(filterKey, this.getFilterKeysStr());
                    throw new IllegalArgumentException(errmsg, ex);
                }
                Restriction<String> restriction = new Restriction<String>(filterKey, op, value);
                this._criteria.put(keyval, restriction);
                this.process(keyval, restriction);
            }
        }
    }

    public static String getDateWithoutOp(String ddf) {
        if (ddf != null) {
            if (ddf.startsWith("=")) {
                return ddf.substring(1, ddf.length());
            }
            if (ddf.startsWith("<=")) {
                return ddf.substring(2, ddf.length());
            }
            if (ddf.startsWith(">=")) {
                return ddf.substring(2, ddf.length());
            }
            if (ddf.startsWith("<")) {
                return ddf.substring(1, ddf.length());
            }
            if (ddf.startsWith(">")) {
                return ddf.substring(1, ddf.length());
            }
        }
        return null;
    }

    protected abstract FKEY parseKey(String var1);

    protected abstract FKEY[] getFilterKeys();

    protected abstract void process(FKEY var1, Restriction<String> var2);

    private Collection<String> getFilterKeysStr() {
        return CollectionsX.transform(new ArrayList(), CollectionUtils.makeCollection(ArrayList.class, this.getFilterKeys()), new UnaryFunction<FKEY, String>(){

            @Override
            public String apply(FKEY x) {
                return ((Enum)x).name();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Restriction<V> {
        public final String originalKey;
        public final String op;
        public final V value;

        public Restriction(String originalKey, String op, V value) {
            this.originalKey = originalKey;
            this.op = op;
            this.value = value;
        }
    }
}

