/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.ProxyConf;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.http.HttpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpHelper {
    private static final Log log = LogFactory.getLog(HttpHelper.class);
    private static final Pattern NON_LWS_PATTERN = Pattern.compile("\r\n([^\\s])");

    public static void configure(HttpClient client, URI targetURI, Element authPart, HttpParams params) throws URIException {
        Element credentialsElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring http client...");
        }
        client.getParams().setDefaults(params);
        client.getParams().setParameter("http.default-headers", (Object)Collections.EMPTY_LIST);
        if (ProxyConf.isProxyEnabled(params, targetURI.getHost())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ProxyConf");
            }
            ProxyConf.configure(client.getHostConfiguration(), client.getState(), (HttpTransportProperties.ProxyProperties)params.getParameter("http.proxy."));
        }
        if (authPart != null && (credentialsElement = DOMUtils.getFirstChildElement(authPart)) != null && credentialsElement.getAttributes().getLength() != 0) {
            String scheme = DOMUtils.getAttribute(credentialsElement, "scheme");
            String username = DOMUtils.getAttribute(credentialsElement, "username");
            String password = DOMUtils.getAttribute(credentialsElement, "password");
            if (!(scheme == null || "server-decides".equalsIgnoreCase(scheme) || "basic".equalsIgnoreCase(scheme) || "digest".equalsIgnoreCase(scheme))) {
                throw new IllegalArgumentException("Unknown Authentication scheme: [" + scheme + "] Accepted values are: Basic, Digest, Server-Decides");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("credentials provided: scheme=" + scheme + " user=" + username + " password=********"));
            }
            client.getState().setCredentials(new AuthScope(targetURI.getHost(), targetURI.getPort(), AuthScope.ANY_REALM, scheme), (Credentials)new UsernamePasswordCredentials(username, password));
            client.getParams().setAuthenticationPreemptive("basic".equalsIgnoreCase(scheme));
        }
    }

    public static Element statusLineToElement(String statusLine) throws HttpException {
        return HttpHelper.statusLineToElement(new StatusLine(statusLine));
    }

    public static Element statusLineToElement(StatusLine statusLine) {
        return HttpHelper.statusLineToElement(DOMUtils.newDocument(), statusLine);
    }

    public static Element statusLineToElement(Document doc, StatusLine statusLine) {
        Element statusLineEl = doc.createElementNS(null, "Status-Line");
        Element versionEl = doc.createElementNS(null, "HTTP-Version");
        Element codeEl = doc.createElementNS(null, "Status-Code");
        Element reasonEl = doc.createElementNS(null, "Reason-Phrase");
        Element originalEl = doc.createElementNS(null, "original");
        doc.appendChild(statusLineEl);
        statusLineEl.appendChild(versionEl);
        statusLineEl.appendChild(codeEl);
        statusLineEl.appendChild(reasonEl);
        statusLineEl.appendChild(originalEl);
        versionEl.setTextContent(statusLine.getHttpVersion());
        codeEl.setTextContent(String.valueOf(statusLine.getStatusCode()));
        reasonEl.setTextContent(statusLine.getReasonPhrase());
        originalEl.setTextContent(statusLine.toString());
        return statusLineEl;
    }

    public static Element prepareDetailsElement(HttpMethod method) {
        Element detailsEl;
        block7: {
            Header h = method.getResponseHeader("Content-Type");
            String receivedType = h != null ? h.getValue() : null;
            boolean bodyIsXml = receivedType != null && HttpUtils.isXml(receivedType);
            Document doc = DOMUtils.newDocument();
            detailsEl = doc.createElementNS(null, "details");
            Element statusLineEl = HttpHelper.statusLineToElement(doc, method.getStatusLine());
            detailsEl.appendChild(statusLineEl);
            try {
                String body = method.getResponseBodyAsString();
                if (!StringUtils.isNotEmpty((String)body)) break block7;
                Element bodyEl = doc.createElementNS(null, "responseBody");
                detailsEl.appendChild(bodyEl);
                boolean exceptionDuringParsing = false;
                if (bodyIsXml) {
                    try {
                        Element parsedBodyEl = DOMUtils.stringToDOM(body);
                        bodyEl.appendChild(doc.importNode(parsedBodyEl, true));
                    }
                    catch (Exception e) {
                        String errmsg = "Unable to parse the response body as xml. Body will be inserted as string.";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)errmsg, (Throwable)e);
                        }
                        exceptionDuringParsing = true;
                    }
                }
                if (!bodyIsXml || exceptionDuringParsing) {
                    bodyEl.setTextContent(body);
                }
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)"Exception while loading response body", (Throwable)e);
            }
        }
        return detailsEl;
    }

    public static String replaceCRLFwithLWS(String header) {
        Matcher m = NON_LWS_PATTERN.matcher(header);
        StringBuffer sb = new StringBuffer(header.length());
        while (m.find()) {
            m.appendReplacement(sb, "\r\n\t");
            sb.append(m.group(1));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String requestToString(HttpMethod m) {
        EntityEnclosingMethod eem;
        StringBuilder sb;
        block6: {
            sb = new StringBuilder(256);
            try {
                sb.append("HTTP Request Details: \n").append(m.getName()).append(" ").append(m.getURI());
            }
            catch (URIException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)e);
            }
        }
        sb.append("\nRequest Headers:");
        Header[] headers = m.getRequestHeaders();
        if (headers.length == 0) {
            sb.append(" n/a");
        }
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            sb.append("\n\t").append(h.getName()).append(": ").append(h.getValue());
        }
        if (m instanceof EntityEnclosingMethod && (eem = (EntityEnclosingMethod)m).getRequestEntity() != null) {
            sb.append("\nRequest Entity:");
            sb.append("\n\tContent-Type:").append(eem.getRequestEntity().getContentType());
            sb.append("\n\tContent-Length:").append(eem.getRequestEntity().getContentLength());
            if (eem.getRequestEntity() instanceof StringRequestEntity) {
                StringRequestEntity sre = (StringRequestEntity)eem.getRequestEntity();
                sb.append("\n\tContent-Charset:").append(sre.getCharset());
                sb.append("\n\tRequest Entity:\n").append(sre.getContent());
            }
        }
        return sb.toString();
    }

    public static String responseToString(HttpMethod m) {
        StringBuilder sb;
        block9: {
            sb = new StringBuilder(256);
            try {
                sb.append("HTTP Response Details: \n").append(m.getName()).append(" ").append(m.getURI());
            }
            catch (URIException e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)e);
            }
        }
        sb.append("\nStatus-Line: ").append(m.getStatusLine());
        Header[] headers = m.getResponseHeaders();
        if (headers.length != 0) {
            sb.append("\nResponse Headers: ");
        }
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            sb.append("\n\t").append(h.getName()).append(": ").append(h.getValue());
        }
        try {
            if (StringUtils.isNotEmpty((String)m.getResponseBodyAsString())) {
                sb.append("\nResponse Entity:\n").append(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        Header[] footers = m.getResponseFooters();
        if (footers.length != 0) {
            sb.append("\nResponse Footers: ");
        }
        for (int i = 0; i < footers.length; ++i) {
            Header h = footers[i];
            sb.append("\n\t").append(h.getName()).append(": ").append(h.getValue());
        }
        return sb.toString();
    }

    public static int isFaultOrFailure(int s) {
        if (s < 400 || s >= 600) {
            throw new IllegalArgumentException("Status-Code must be in interval [400;600[");
        }
        if (s == 500 || s == 501 || s == 502 || s == 505 || s == 400 || s == 402 || s == 403 || s == 404 || s == 405 || s == 406 || s == 407 || s == 409 || s == 410 || s == 412 || s == 413 || s == 414 || s == 415 || s == 411 || s == 416 || s == 417) {
            return 1;
        }
        if (s == 503 || s == 504 || s == 401 || s == 408) {
            return -1;
        }
        return 0;
    }
}

