/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.osgi.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.osgi.PersistenceActivator;
import org.apache.openjpa.osgi.deployment.CompositeClassLoader;
import org.apache.openjpa.osgi.deployment.OSGiBundleProxyClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiAwareClassLoaderManager {
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());
    private Map<String, ClassLoader> puClassLoaders = new HashMap<String, ClassLoader>();

    public static void addBundle(Bundle bundle, String[] persistenceUnitNames) {
        for (int i = 0; i < persistenceUnitNames.length; ++i) {
            String name = persistenceUnitNames[i];
            puToBundle.put(name, bundle);
        }
        bundleToPUs.put(bundle, persistenceUnitNames);
    }

    public static void removeBundle(Bundle bundle) {
        String[] persistenceUnitNames = bundleToPUs.remove(bundle);
        if (persistenceUnitNames != null) {
            for (int i = 0; i < persistenceUnitNames.length; ++i) {
                String name = persistenceUnitNames[i];
                puToBundle.remove(name);
            }
        }
    }

    public static boolean includesBundle(Bundle bundle) {
        return bundleToPUs.containsKey(bundle);
    }

    public ClassLoader getClassLoader(String persistenceUnitName) {
        ClassLoader previouslyDefinedLoader = this.puClassLoaders.get(persistenceUnitName);
        if (previouslyDefinedLoader != null) {
            return previouslyDefinedLoader;
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        Bundle bundle = puToBundle.get(persistenceUnitName);
        if (bundle != null) {
            OSGiBundleProxyClassLoader bundleClassLoader = new OSGiBundleProxyClassLoader(bundle);
            loaders.add(bundleClassLoader);
        }
        if (bundle == null) {
            return null;
        }
        BundleContext context = PersistenceActivator.getContext();
        if (context != null) {
            OSGiBundleProxyClassLoader eclipseLinkJpaClassLoader = new OSGiBundleProxyClassLoader(context.getBundle());
            loaders.add(eclipseLinkJpaClassLoader);
        }
        CompositeClassLoader puClassLoader = new CompositeClassLoader(loaders);
        this.puClassLoaders.put(persistenceUnitName, puClassLoader);
        return puClassLoader;
    }
}

