/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.osgi.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.openjpa.osgi.deployment.CompositeEnumeration;

public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public CompositeClassLoader(List<ClassLoader> loaders) {
        this.classLoaders.addAll(loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.clearAssertionStatus();
        }
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList enumerations = new ArrayList(this.getClassLoaders().size());
        for (int i = 0; i < this.getClassLoaders().size(); ++i) {
            enumerations.add(i, this.getClassLoaders().get(i).getResources(name));
        }
        return new CompositeEnumeration<URL>(enumerations);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                Class<?> aClass = classLoader.loadClass(name);
                return aClass;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setPackageAssertionStatus(packageName, enabled);
        }
    }
}

