/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.osgi;

import java.util.Hashtable;
import javax.persistence.spi.PersistenceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.osgi.OSGiPersistenceProviderImpl;
import org.apache.openjpa.osgi.deployment.OSGiAwareClassLoaderManager;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class PersistenceActivator
implements BundleActivator,
SynchronousBundleListener {
    private static Log log = LogFactory.getLog(PersistenceActivator.class);
    public static final String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
    public static final String OSGI_PERSISTENCE_PROVIDER = PersistenceProviderImpl.class.getName();
    private static BundleContext ctx = null;

    public void start(BundleContext arg0) throws Exception {
        ctx = arg0;
        this.registerBundleListener();
        OSGiPersistenceProviderImpl provider = new OSGiPersistenceProviderImpl();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(PERSISTENCE_PROVIDER, OSGI_PERSISTENCE_PROVIDER);
        ctx.registerService(PERSISTENCE_PROVIDER, (Object)provider, props);
    }

    public void stop(BundleContext arg0) throws Exception {
        PersistenceActivator.getContext().removeBundleListener((BundleListener)this);
    }

    private void registerBundleListener() {
        PersistenceActivator.getContext().addBundleListener((BundleListener)this);
        Bundle[] bundles = PersistenceActivator.getContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            this.registerBundle(bundle);
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        switch (bundleEvent.getType()) {
            case 128: {
                this.registerBundle(bundleEvent.getBundle());
                break;
            }
            case 256: {
                this.deregisterBundle(bundleEvent.getBundle());
            }
        }
    }

    private void registerBundle(Bundle bundle) {
        if ((bundle.getState() & 0x2C) != 0 && !OSGiAwareClassLoaderManager.includesBundle(bundle)) {
            try {
                String[] persistenceUnitNames = this.getPersistenceUnitNames(bundle);
                if (persistenceUnitNames != null) {
                    OSGiAwareClassLoaderManager.addBundle(bundle, persistenceUnitNames);
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    private String[] getPersistenceUnitNames(Bundle bundle) {
        String names = (String)bundle.getHeaders().get("JPA-PersistenceUnits");
        if (names != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JPA-PersistenceUnits:" + names));
            }
            return names.split(",");
        }
        return null;
    }

    private void deregisterBundle(Bundle bundle) {
        OSGiAwareClassLoaderManager.removeBundle(bundle);
    }

    public static BundleContext getContext() {
        return ctx;
    }
}

