/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.osgi;

import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.osgi.OSGiPersistenceProductDerivation;
import org.apache.openjpa.osgi.deployment.OSGiAwareClassLoaderManager;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.osgi.BundleUtils;

public class OSGiPersistenceProviderImpl
extends PersistenceProviderImpl {
    private OSGiAwareClassLoaderManager classLoaderManager = new OSGiAwareClassLoaderManager();

    @Override
    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource, Map m) {
        OSGiPersistenceProductDerivation pd = new OSGiPersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty("EntityManagerFactoryPool", m);
            if (this.classLoaderManager == null) {
                throw new PersistenceException("OSGiAwareClasssLoaderManager null.", null, null, true);
            }
            ConfigurationProvider cp = pd.load(resource, name, m, this.classLoaderManager.getClassLoader(name));
            if (cp == null) {
                return null;
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, BundleUtils.getBundleClassLoader());
            OpenJPAConfiguration conf = factory.getConfiguration();
            this._log = conf.getLog("openjpa.Runtime");
            pd.checkPuNameCollisions(this._log, name);
            this.loadAgent(factory);
            this.loadValidator(factory);
            if (conf.getConnectionRetainModeConstant() == 2) {
                this._log.warn(_loc.get("retain-always", conf.getId()));
            }
            OpenJPAEntityManagerFactory emf = JPAFacadeHelper.toEntityManagerFactory(factory);
            if (this._log.isTraceEnabled()) {
                this._log.trace(this + " creating " + emf + " for PU " + name + ".");
            }
            return emf;
        }
        catch (Exception e) {
            if (this._log != null) {
                this._log.error(_loc.get("create-emf-error", name), e);
            }
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }
}

