/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;

public abstract class Store
extends Service {
    private static final Folder[] FOLDER_ARRAY = new Folder[0];
    private final Vector folderListeners = new Vector(2);
    private final Vector storeListeners = new Vector(2);

    protected Store(Session session, URLName name) {
        super(session, name);
    }

    public abstract Folder getDefaultFolder() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract Folder getFolder(URLName var1) throws MessagingException;

    public Folder[] getPersonalNamespaces() throws MessagingException {
        return new Folder[]{this.getDefaultFolder()};
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        return FOLDER_ARRAY;
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return FOLDER_ARRAY;
    }

    public void addStoreListener(StoreListener listener) {
        this.storeListeners.add(listener);
    }

    public void removeStoreListener(StoreListener listener) {
        this.storeListeners.remove(listener);
    }

    protected void notifyStoreListeners(int type, String message) {
        this.queueEvent((MailEvent)new StoreEvent(this, type, message), this.storeListeners);
    }

    public void addFolderListener(FolderListener listener) {
        this.folderListeners.add(listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this.folderListeners.remove(listener);
    }

    protected void notifyFolderListeners(int type, Folder folder) {
        this.queueEvent((MailEvent)new FolderEvent((Object)this, folder, type), this.folderListeners);
    }

    protected void notifyFolderRenamedListeners(Folder oldFolder, Folder newFolder) {
        this.queueEvent((MailEvent)new FolderEvent((Object)this, oldFolder, newFolder, 3), this.folderListeners);
    }
}

