/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.EventQueue;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service {
    protected Session session;
    protected URLName url;
    protected boolean debug;
    private boolean connected;
    private final Vector connectionListeners = new Vector(2);
    private final EventQueue queue = new EventQueue();

    protected Service(Session session, URLName url) {
        this.session = session;
        this.url = url;
    }

    public void connect() throws MessagingException {
        this.connect(null, null, null);
    }

    public void connect(String host, String user, String password) throws MessagingException {
        this.connect(host, -1, user, password);
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        boolean connected = this.protocolConnect(host, port, user, password);
        if (!connected) {
            connected = this.protocolConnect(host, port, user, password);
        }
        this.setConnected(connected);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void close() throws MessagingException {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public URLName getURLName() {
        return this.url == null ? null : new URLName(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), null, this.url.getUsername(), null);
    }

    protected void setURLName(URLName url) {
        this.url = url;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void notifyConnectionListeners(int type) {
        this.queue.queueEvent((MailEvent)new ConnectionEvent((Object)this, type), this.connectionListeners);
    }

    public String toString() {
        return this.url == null ? super.toString() : this.url.toString();
    }

    protected void queueEvent(MailEvent event, Vector listeners) {
        this.queue.queueEvent(event, listeners);
    }

    protected void finalize() throws Throwable {
        this.queue.stop();
        this.connectionListeners.clear();
        super.finalize();
    }
}

