/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.VariableContext;

public class SequenceEvaluator
implements Selectable {
    private boolean _nextval;
    private VariableContext _ctx = null;
    private Sequence _seq = null;

    public SequenceEvaluator(Sequence seq, String method) throws AxionException {
        this._seq = seq;
        if ("NEXTVAL".equalsIgnoreCase(method)) {
            this._nextval = true;
        } else if ("CURRVAL".equalsIgnoreCase(method)) {
            this._nextval = false;
        } else {
            throw new AxionException("Pseudocolumn " + method + " not recognized.");
        }
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        if (this._nextval) {
            Object val = this._seq.evaluate(row);
            this._ctx.put(this._seq, val);
            return val;
        }
        if (this._ctx.containsKey(this._seq)) {
            return this._ctx.get(this._seq);
        }
        throw new AxionException("Sequence " + this.getName() + " not yet evaluated in this context.");
    }

    public DataType getDataType() {
        return this._seq.getDataType();
    }

    public String getLabel() {
        return this._seq.getLabel();
    }

    public String getName() {
        return this._seq.getName();
    }

    public void setVariableContext(VariableContext ctx) {
        this._ctx = ctx;
    }
}

