/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.LimitedProcessInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessStatus;
import org.wso2.carbon.context.CarbonContext;

public class AdminServiceUtils {
    public static LimitedProcessInfoType createLimitedProcessInfoObject(ProcessConf processConf) {
        LimitedProcessInfoType processInfoObject = new LimitedProcessInfoType();
        processInfoObject.setPid(processConf.getProcessId().toString());
        processInfoObject.setDeployedDate(AdminServiceUtils.toCalendar(processConf.getDeployDate()));
        processInfoObject.setVersion(processConf.getVersion());
        if (processConf.getState() == ProcessState.RETIRED) {
            processInfoObject.setStatus(ProcessStatus.RETIRED);
        } else if (processConf.getState() == ProcessState.DISABLED) {
            processInfoObject.setStatus(ProcessStatus.DISABLED);
        } else {
            processInfoObject.setStatus(ProcessStatus.ACTIVE);
        }
        if (processConf.getState() == ProcessState.RETIRED) {
            processInfoObject.setStatus(ProcessStatus.RETIRED);
            processInfoObject.setOlderVersion(AdminServiceUtils.isOlderVersion(processConf, AdminServiceUtils.getTenantProcessStore()));
        } else if (processConf.getState() == ProcessState.DISABLED) {
            processInfoObject.setStatus(ProcessStatus.DISABLED);
            processInfoObject.setOlderVersion(0);
        } else {
            processInfoObject.setStatus(ProcessStatus.ACTIVE);
            processInfoObject.setOlderVersion(0);
        }
        processInfoObject.setPackageName(processConf.getPackage());
        return processInfoObject;
    }

    public static Calendar toCalendar(Date dtime) {
        if (dtime == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(dtime);
        return c;
    }

    public static int isOlderVersion(ProcessConf pconf, TenantProcessStoreImpl tenantProcessStore) {
        Set<QName> processIDs = tenantProcessStore.getProcessConfigMap().keySet();
        String filter = pconf.getProcessId().getLocalPart().substring(0, pconf.getProcessId().getLocalPart().lastIndexOf("-"));
        Pattern pattern = Pattern.compile(filter.replace("*", ".*") + "(-\\d*)?");
        ArrayList<QName> pids = new ArrayList<QName>();
        for (QName pid : processIDs) {
            if (!pattern.matcher(pid.getLocalPart()).matches()) continue;
            pids.add(pid);
        }
        if (pids.size() > 1) {
            long currentVersion = pconf.getVersion();
            for (QName pid : pids) {
                long tempVersion = Long.parseLong(pid.getLocalPart().substring(pid.getLocalPart().lastIndexOf("-") + 1));
                if (tempVersion <= currentVersion) continue;
                return 1;
            }
        }
        return 0;
    }

    public static TenantProcessStoreImpl getTenantProcessStore() {
        return (TenantProcessStoreImpl)BPELServerImpl.getInstance().getMultiTenantProcessStore().getTenantsProcessStore(CarbonContext.getCurrentContext().getTenantId());
    }
}

