/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evtproc.ActivityStateDocumentBuilder;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;
import org.wso2.carbon.bpel.core.ode.integration.utils.ActivityInfoWithEventsDocument;

public class ActivityStateAndEventDocumentBuilder
extends ActivityStateDocumentBuilder
implements BpelEventListener {
    private List<ActivityInfoWithEventsDocument> activitiesWithEventsOrdered = new ArrayList<ActivityInfoWithEventsDocument>();
    private Map<Long, ActivityInfoWithEventsDocument> activitiesWithEvents = new HashMap<Long, ActivityInfoWithEventsDocument>();

    public void onEvent(BpelEvent be) {
        super.onEvent(be);
        List infoDocList = super.getActivities();
        if (be instanceof ActivityEvent) {
            ActivityEvent event = (ActivityEvent)be;
            this.fillActivityInfo(event, infoDocList);
            ActivityInfoWithEventsDocument actinf = this.lookup(event);
            assert (actinf != null);
        }
    }

    private void fillActivityInfo(ActivityEvent be, List<ActivityInfoDocument> infoDocList) {
        ActivityInfoDocument infoDoc = null;
        for (ActivityInfoDocument inf : infoDocList) {
            if (!inf.getActivityInfo().getAiid().equals(String.valueOf(be.getActivityId()))) continue;
            infoDoc = inf;
        }
        if (this.activitiesWithEvents.get(be.getActivityId()) == null) {
            this.activitiesWithEvents.put(be.getActivityId(), new ActivityInfoWithEventsDocument(infoDoc));
        }
        this.addActivitiesWithEventOrdered(infoDoc);
    }

    private ActivityInfoWithEventsDocument lookup(ActivityEvent event) {
        TEventInfo eventInfo;
        ActivityInfoWithEventsDocument actEvtInfoDoc = this.activitiesWithEvents.get(event.getActivityId());
        ActivityInfoDocument aInfo = actEvtInfoDoc.getActivityInfoDoc();
        EventInfoListDocument aEventList = actEvtInfoDoc.getEventInfoList();
        if (aEventList == null) {
            aEventList = EventInfoListDocument.Factory.newInstance();
            actEvtInfoDoc.setEventInfoList(aEventList);
            aEventList = actEvtInfoDoc.getEventInfoList();
        }
        if (aEventList.getEventInfoList() == null) {
            TEventInfoList eventInfoList = aEventList.addNewEventInfoList();
            eventInfo = eventInfoList.addNewEventInfo();
        } else {
            eventInfo = aEventList.getEventInfoList().addNewEventInfo();
        }
        this.fillEventInfo(eventInfo, event);
        this.addActivitiesWithEventOrdered(event, new ActivityInfoWithEventsDocument(aInfo, aEventList));
        return this.activitiesWithEvents.get(event.getActivityId());
    }

    private void addActivitiesWithEventOrdered(ActivityInfoDocument infoDoc) {
        boolean isExist = false;
        for (ActivityInfoWithEventsDocument anActivitiesWithEventsOrdered : this.activitiesWithEventsOrdered) {
            if (!anActivitiesWithEventsOrdered.getActivityInfoDoc().getActivityInfo().getAiid().equals(infoDoc.getActivityInfo().getAiid())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.activitiesWithEventsOrdered.add(new ActivityInfoWithEventsDocument(infoDoc));
        }
    }

    private void addActivitiesWithEventOrdered(ActivityEvent event, ActivityInfoWithEventsDocument infoWithEventsDoc) {
        boolean isExist = false;
        for (ActivityInfoWithEventsDocument anActivitiesWithEventsOrdered : this.activitiesWithEventsOrdered) {
            TEventInfo eventInfo;
            if (!anActivitiesWithEventsOrdered.getActivityInfoDoc().getActivityInfo().getAiid().equals(infoWithEventsDoc.getActivityInfoDoc().getActivityInfo().getAiid())) continue;
            isExist = true;
            EventInfoListDocument aEventList = anActivitiesWithEventsOrdered.getEventInfoList();
            if (aEventList == null) {
                aEventList = EventInfoListDocument.Factory.newInstance();
                anActivitiesWithEventsOrdered.setEventInfoList(aEventList);
                aEventList = anActivitiesWithEventsOrdered.getEventInfoList();
            }
            if (aEventList.getEventInfoList() == null) {
                TEventInfoList eventInfoList = aEventList.addNewEventInfoList();
                eventInfo = eventInfoList.addNewEventInfo();
            } else {
                eventInfo = aEventList.getEventInfoList().addNewEventInfo();
            }
            this.fillEventInfo(eventInfo, event);
            break;
        }
        if (!isExist) {
            this.activitiesWithEventsOrdered.add(infoWithEventsDoc);
        }
    }

    private void fillEventInfo(TEventInfo info, ActivityEvent event) {
        info.setActivityType(event.getActivityType());
        info.setActivityDefinitionId(event.getActivityDeclarationId());
        info.setActivityId(event.getActivityId());
        info.setActivityName(event.getActivityName());
        info.setLineNumber(event.getLineNo());
        info.setName(BpelEvent.eventName((BpelEvent)event));
        info.setProcessId(event.getProcessId());
        info.setScopeId(event.getScopeId().longValue());
        info.setScopeName(event.getScopeName());
        info.setTimestamp(this.convertDatetoCalendar(event.getTimestamp()));
        info.setType(event.getType().toString());
    }

    private Calendar convertDatetoCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public List<ActivityInfoWithEventsDocument> getActivitiesWithEvents() {
        return this.activitiesWithEventsOrdered;
    }

    public void startup(Properties properties) {
    }

    public void shutdown() {
    }
}

