/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.store.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.wso2.carbon.bpel.core.ode.integration.store.BPELDeploymentContext;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CategoryListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Category_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CleanUpType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EnableEventListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Generate_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.On_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeEventType;

public final class BPELPackageRepositoryUtils {
    private BPELPackageRepositoryUtils() {
    }

    public static String getResourcePathForDeployInfoUpdatedBPELPackage(String packageName, String versionlessPackageName) {
        return "/bpel/packages/" + versionlessPackageName + "/versions/" + packageName;
    }

    public static String getResourcePathForBPELPackage(BPELDeploymentContext deploymentContext) {
        return "/bpel/packages/" + deploymentContext.getBpelPackageName();
    }

    public static String getResourcePathForBPELPackage(String packageName) {
        return "/bpel/packages/" + packageName;
    }

    public static String getResourcePathForBPELPackageContent(BPELDeploymentContext deploymentContext) {
        return "/bpel/packages/" + deploymentContext.getBpelPackageName() + "/versions/" + deploymentContext.getBpelPackageNameWithVersion();
    }

    public static String getResourcePathForBPELPackageVersions(BPELDeploymentContext deploymentContext) {
        return "/bpel/packages/" + deploymentContext.getBpelPackageName() + "/versions/";
    }

    public static String getBPELPackageArchiveResourcePath(String bpelPackageName) {
        return "/bpel/packages/".concat(bpelPackageName).concat("/").concat(bpelPackageName).concat(".zip");
    }

    protected static String getBPELPackageProcessEventsInList(Map<String, Set<BpelEvent.TYPE>> events) {
        String enabledEventsList = "";
        if (events != null) {
            Set<Map.Entry<String, Set<BpelEvent.TYPE>>> eventEntries = events.entrySet();
            for (Map.Entry<String, Set<BpelEvent.TYPE>> entry : eventEntries) {
                if (entry.getKey() != null) continue;
                HashSet evtSet = (HashSet)entry.getValue();
                for (BpelEvent.TYPE type : evtSet) {
                    enabledEventsList = enabledEventsList.concat(type.name() + ",");
                }
            }
        }
        return enabledEventsList;
    }

    protected static List<String> getBPELPackageScopeEventsInList(Map<String, Set<BpelEvent.TYPE>> events) {
        ArrayList<String> scopeEvents = new ArrayList<String>();
        if (events != null) {
            Set<Map.Entry<String, Set<BpelEvent.TYPE>>> eventEntries = events.entrySet();
            for (Map.Entry<String, Set<BpelEvent.TYPE>> entry : eventEntries) {
                if (entry.getKey() == null) continue;
                String scopeEventEntry = "";
                scopeEventEntry = scopeEventEntry.concat(entry.getKey() + ",");
                HashSet evtSet = (HashSet)entry.getValue();
                for (BpelEvent.TYPE type : evtSet) {
                    scopeEventEntry = scopeEventEntry.concat(type.name() + ",");
                }
                scopeEvents.add(scopeEventEntry);
            }
        }
        return scopeEvents;
    }

    public static String getBPELPackageSuccessCleanUpsInList(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories) {
        String successCleanUpsList = "";
        if (cleanupCategories != null) {
            for (ProcessConf.CLEANUP_CATEGORY category : cleanupCategories) {
                successCleanUpsList = successCleanUpsList.concat(category.name() + ",");
            }
            if (!successCleanUpsList.equalsIgnoreCase("")) {
                successCleanUpsList = successCleanUpsList.substring(0, successCleanUpsList.lastIndexOf(44));
            }
        }
        return successCleanUpsList;
    }

    public static String getBPELPackageFailureCleanUpsAsString(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories) {
        String failureCleanUpsList = "";
        if (cleanupCategories != null) {
            for (ProcessConf.CLEANUP_CATEGORY category : cleanupCategories) {
                failureCleanUpsList = failureCleanUpsList.concat(category.name() + ",");
            }
            if (!failureCleanUpsList.equalsIgnoreCase("")) {
                failureCleanUpsList = failureCleanUpsList.substring(0, failureCleanUpsList.lastIndexOf(44));
            }
        }
        return failureCleanUpsList;
    }

    public static String getBPELPackageProcessGenerateType(TProcessEvents.Generate.Enum generateType) {
        if (generateType != null) {
            return generateType.toString();
        }
        return "";
    }

    public static ProcessState getProcessState(String stateInString) {
        if (stateInString.equalsIgnoreCase("ACTIVE")) {
            return ProcessState.ACTIVE;
        }
        if (stateInString.equalsIgnoreCase("RETIRED")) {
            return ProcessState.RETIRED;
        }
        return ProcessState.DISABLED;
    }

    public static String getVersionlessPackageName(String packageName) throws ProcessManagementException {
        String tPackageName = packageName;
        if (tPackageName != null) {
            tPackageName = tPackageName.substring(0, tPackageName.lastIndexOf(45));
        }
        return tPackageName;
    }

    public static EnableEventListType getEnabledEventsListFromString(String processEventsInString) {
        String[] enabledEvents;
        EnableEventListType enableEventListType = new EnableEventListType();
        for (String event : enabledEvents = BPELPackageRepositoryUtils.getStringsFromArray(processEventsInString)) {
            enableEventListType.addEnableEvent(event);
        }
        return enableEventListType;
    }

    public static Generate_type1 getProcessGenerateTypeFromString(String generateTypeString) {
        return Generate_type1.Factory.fromValue((String)generateTypeString);
    }

    public static ScopeEventType getScopeEventFromString(String scopeEventInString) {
        ScopeEventType scopeEvent = new ScopeEventType();
        EnableEventListType enableEventListType = new EnableEventListType();
        String[] scopeEventEntries = BPELPackageRepositoryUtils.getStringsFromArray(scopeEventInString);
        for (int i = 0; i < scopeEventEntries.length - 1; ++i) {
            enableEventListType.addEnableEvent(scopeEventEntries[i + 1]);
        }
        scopeEvent.setScope(scopeEventEntries[0]);
        scopeEvent.setEnabledEventList(enableEventListType);
        return scopeEvent;
    }

    public static CleanUpType getSuccessCleanUpType(String successCleanupsInString) {
        CleanUpType successCleanUp = new CleanUpType();
        String[] successCategories = BPELPackageRepositoryUtils.getStringsFromArray(successCleanupsInString);
        CategoryListType categoryList = new CategoryListType();
        for (String category : successCategories) {
            Category_type1 categoryType1 = Category_type1.Factory.fromValue((String)category.toLowerCase());
            categoryList.addCategory(categoryType1);
        }
        successCleanUp.setOn(On_type1.success);
        successCleanUp.setCategoryList(categoryList);
        return successCleanUp;
    }

    public static CleanUpType getFailureCleanUpType(String failureCleanupsInString) {
        CleanUpType failureCleanUp = new CleanUpType();
        String[] failureCategories = BPELPackageRepositoryUtils.getStringsFromArray(failureCleanupsInString);
        CategoryListType categoryList = new CategoryListType();
        for (String category : failureCategories) {
            Category_type1 categoryType1 = Category_type1.Factory.fromValue((String)category.toLowerCase());
            categoryList.addCategory(categoryType1);
        }
        failureCleanUp.setOn(On_type1.failure);
        failureCleanUp.setCategoryList(categoryList);
        return failureCleanUp;
    }

    public static String[] getStringsFromArray(String eventsInString) {
        if (!eventsInString.isEmpty()) {
            return eventsInString.split(",");
        }
        return new String[0];
    }
}

