/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration.mgt.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TCleanup;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.dd.TScopeEvents;
import org.apache.ode.bpel.dd.TService;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.core.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.core.ode.integration.utils.AdminServiceUtils;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementServiceSkeletonInterface;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.BpelDefinition;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CategoryListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Category_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CleanUpListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.CleanUpType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DefinitionInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DeploymentInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EnableEventListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EndpointRef_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EndpointReferencesType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.FailuresInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Generate_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceStatus;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceSummary;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Instances_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InvokeServiceListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InvokedServiceType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.MexInterpreterListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.On_type1;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PaginatedProcessInfoList;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessDeployDetailsList;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessDeployDetailsList_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessEventsListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessProperties;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessProperty_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessStatus;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PropertyListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Property_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProvideServiceListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProvidedServiceType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeEventListType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ScopeEventType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ServiceLocation;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Service_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Service_type1;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.service.mgt.util.Utils;

public class ProcessManagementServiceSkeleton
extends AbstractAdmin
implements ProcessManagementServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(ProcessManagementServiceSkeleton.class);
    private BPELServerImpl bpelServer = BPELServerImpl.getInstance();
    private BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();

    public PaginatedProcessInfoList getPaginatedProcessList(String processListFilter, String processListOrderByKey, int page) throws ProcessManagementException {
        int tPage = page;
        PaginatedProcessInfoList processList = new PaginatedProcessInfoList();
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        if (tPage < 0 || tPage == Integer.MAX_VALUE) {
            tPage = 0;
        }
        Integer itemsPerPage = 10;
        Integer startIndexForCurrentPage = tPage * itemsPerPage;
        Integer endIndexForCurrentPage = (tPage + 1) * itemsPerPage;
        ProcessFilter processFilter = new ProcessFilter(processListFilter, processListOrderByKey);
        Collection<ProcessConf> processListForCurrentPage = this.processQuery(processFilter, tenantProcessStore);
        Integer processListSize = processListForCurrentPage.size();
        Integer pages = (int)Math.ceil((double)processListSize.intValue() / (double)itemsPerPage.intValue());
        processList.setPages(pages.intValue());
        ProcessConf[] processConfigurations = processListForCurrentPage.toArray(new ProcessConf[processListSize.intValue()]);
        for (int i = startIndexForCurrentPage.intValue(); i < endIndexForCurrentPage && i < processListSize; ++i) {
            processList.addProcessInfo(AdminServiceUtils.createLimitedProcessInfoObject(processConfigurations[i]));
        }
        return processList;
    }

    public String[] getAllProcesses(String getAllProcesses) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        Set<QName> processIds = tenantProcessStore.getProcessConfigMap().keySet();
        ArrayList<String> pids = new ArrayList<String>();
        for (QName pid : processIds) {
            pids.add(pid.toString());
        }
        return pids.toArray(new String[pids.size()]);
    }

    public ProcessDeployDetailsList_type0 getProcessDeploymentInfo(QName pid) {
        Category_type1 categoryType1;
        CategoryListType categoryListType;
        On_type1 onType;
        CleanUpType cleanUp;
        List<TProvide> provideList;
        ProcessDeployDetailsList processDeployDetailsList = new ProcessDeployDetailsList();
        ProcessDeployDetailsList_type0 processDeployDetailsListType = new ProcessDeployDetailsList_type0();
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        ProcessConf processConf = tenantProcessStore.getProcessConfiguration(pid);
        ProcessConfigurationImpl processConfiguration = (ProcessConfigurationImpl)processConf;
        QName processId = processConfiguration.getProcessId();
        processDeployDetailsListType.setProcessName(processId);
        ProcessStatus processStatus = ProcessStatus.Factory.fromValue((String)processConfiguration.getState().name());
        processDeployDetailsListType.setProcessState(processStatus);
        processDeployDetailsListType.setIsInMemory(processConfiguration.isTransient());
        List<TInvoke> invokeList = processConfiguration.getInvokedServices();
        if (invokeList != null) {
            InvokeServiceListType ist = new InvokeServiceListType();
            for (TInvoke invoke : invokeList) {
                InvokedServiceType invokedServiceType = new InvokedServiceType();
                Service_type1 service = new Service_type1();
                service.setName(invoke.getService().getName());
                service.setPort(invoke.getService().getPort());
                invokedServiceType.setService(service);
                invokedServiceType.setPartnerLink(invoke.getPartnerLink());
                ist.addInvokedService(invokedServiceType);
                processDeployDetailsListType.setInvokeServiceList(ist);
            }
        }
        if ((provideList = processConfiguration.getProvidedServices()) != null) {
            ProvideServiceListType pst = new ProvideServiceListType();
            for (TProvide provide : provideList) {
                ProvidedServiceType providedServiceType = new ProvidedServiceType();
                Service_type0 service = new Service_type0();
                service.setName(provide.getService().getName());
                service.setPort(provide.getService().getPort());
                providedServiceType.setService(service);
                providedServiceType.setPartnerLink(provide.getPartnerLink());
                pst.addProvidedService(providedServiceType);
            }
            processDeployDetailsListType.setProvideServiceList(pst);
        }
        MexInterpreterListType mxt = new MexInterpreterListType();
        List<String> mexInterceptor = processConfiguration.getMexInterceptors();
        if (mexInterceptor != null) {
            for (String mexInt : mexInterceptor) {
                mxt.addMexinterpreter(mexInt);
            }
        }
        processDeployDetailsListType.setMexInterperterList(mxt);
        Map<String, Set<BpelEvent.TYPE>> eventsMap = processConfiguration.getEvents();
        ProcessEventsListType processEventsListType = new ProcessEventsListType();
        EnableEventListType enableEventListType = new EnableEventListType();
        ScopeEventListType scopeEventListType = new ScopeEventListType();
        for (Map.Entry<String, Set<BpelEvent.TYPE>> eventEntry : eventsMap.entrySet()) {
            if (eventEntry.getKey() != null) {
                ScopeEventType scopeEvent = new ScopeEventType();
                String scopeName = eventEntry.getKey();
                EnableEventListType enableEventList = new EnableEventListType();
                Set<BpelEvent.TYPE> typeSetforScope = eventEntry.getValue();
                for (BpelEvent.TYPE type : typeSetforScope) {
                    enableEventList.addEnableEvent(type.toString());
                }
                scopeEvent.setScope(scopeName);
                scopeEvent.setEnabledEventList(enableEventList);
                scopeEventListType.addScopeEvent(scopeEvent);
                continue;
            }
            Set<BpelEvent.TYPE> typeSet = eventEntry.getValue();
            for (BpelEvent.TYPE aTypeSet : typeSet) {
                enableEventListType.addEnableEvent(aTypeSet.toString());
            }
        }
        TProcessEvents.Generate.Enum genEnum = processConfiguration.getGenerateType();
        if (genEnum != null) {
            Generate_type1 generate = Generate_type1.Factory.fromValue((String)genEnum.toString());
            processEventsListType.setGenerate(generate);
        }
        processEventsListType.setEnableEventsList(enableEventListType);
        processEventsListType.setScopeEventsList(scopeEventListType);
        processDeployDetailsListType.setProcessEventsList(processEventsListType);
        PropertyListType propertyListType = new PropertyListType();
        Map<QName, Node> propertiesMap = processConfiguration.getProcessProperties();
        Set<Map.Entry<QName, Node>> entries = propertiesMap.entrySet();
        for (Map.Entry<QName, Node> entry : entries) {
            ProcessProperty_type0 property = new ProcessProperty_type0();
            property.setName(entry.getKey());
            Node node = entry.getValue();
            property.setValue(DOMUtils.domToStringLevel2((Node)node));
            propertyListType.addProcessProperty(property);
        }
        processDeployDetailsListType.setPropertyList(propertyListType);
        CleanUpListType cleanUpList = new CleanUpListType();
        Set<ProcessConf.CLEANUP_CATEGORY> sucessTypeCleanups = processConfiguration.getCleanupCategories(true);
        Set<ProcessConf.CLEANUP_CATEGORY> failureTypeCleanups = processConfiguration.getCleanupCategories(false);
        if (sucessTypeCleanups != null) {
            cleanUp = new CleanUpType();
            onType = On_type1.success;
            cleanUp.setOn(onType);
            categoryListType = new CategoryListType();
            for (ProcessConf.CLEANUP_CATEGORY sCategory : sucessTypeCleanups) {
                categoryType1 = Category_type1.Factory.fromValue((String)sCategory.name().toLowerCase());
                categoryListType.addCategory(categoryType1);
            }
            cleanUp.setCategoryList(categoryListType);
            cleanUpList.addCleanUp(cleanUp);
        }
        if (failureTypeCleanups != null) {
            cleanUp = new CleanUpType();
            onType = On_type1.failure;
            cleanUp.setOn(onType);
            categoryListType = new CategoryListType();
            for (ProcessConf.CLEANUP_CATEGORY fCategory : failureTypeCleanups) {
                categoryType1 = Category_type1.Factory.fromValue((String)fCategory.name().toLowerCase());
                categoryListType.addCategory(categoryType1);
            }
            cleanUp.setCategoryList(categoryListType);
            cleanUpList.addCleanUp(cleanUp);
        }
        processDeployDetailsListType.setCleanUpList(cleanUpList);
        processDeployDetailsList.setProcessDeployDetailsList(processDeployDetailsListType);
        return processDeployDetailsListType;
    }

    public void updateDeployInfo(ProcessDeployDetailsList_type0 processDeployDetailsListType) throws ProcessManagementException {
        final QName processId = processDeployDetailsListType.getProcessName();
        try {
            TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
            ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)tenantProcessStore.getProcessConfiguration(processId);
            final boolean oldIsInmemory = processConf.isTransient();
            final boolean newIsInmemory = processDeployDetailsListType.getIsInMemory();
            processConf.setState(this.getProcessState(processDeployDetailsListType));
            processConf.setIsTransient(newIsInmemory);
            processConf.setProcessEventsList(processDeployDetailsListType.getProcessEventsList());
            processConf.setGenerateType(processDeployDetailsListType.getProcessEventsList());
            processConf.setProcessCleanupConfImpl(processDeployDetailsListType.getCleanUpList());
            this.persistDeployDescInFile(processDeployDetailsListType, processConf, newIsInmemory);
            this.bpelServer.getODEBPELServer().getContexts().scheduler.execTransaction((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    block5: {
                        block4: {
                            if (!(oldIsInmemory & !newIsInmemory)) break block4;
                            ProcessDAO processDAO = ProcessManagementServiceSkeleton.this.bpelServer.getODEBPELServer().getContexts().getInMemDao().getConnection().getProcess(processId);
                            if (((ProcessManagementServiceSkeleton)ProcessManagementServiceSkeleton.this).bpelServer.getODEBPELServer().getContexts().dao.getConnection().getProcess(processId) != null) break block5;
                            ProcessDAO newProcessDAO = ((ProcessManagementServiceSkeleton)ProcessManagementServiceSkeleton.this).bpelServer.getODEBPELServer().getContexts().dao.getConnection().createProcess(processDAO.getProcessId(), processDAO.getType(), processDAO.getGuid(), processDAO.getVersion());
                            Set correlatorsSet = processDAO.getCorrelatorsSet();
                            for (String correlator : correlatorsSet) {
                                newProcessDAO.addCorrelator(correlator);
                            }
                            break block5;
                        }
                        if (!oldIsInmemory & newIsInmemory) {
                            QName pId = processId;
                            ProcessDAO processDAO = ((ProcessManagementServiceSkeleton)ProcessManagementServiceSkeleton.this).bpelServer.getODEBPELServer().getContexts().dao.getConnection().getProcess(pId);
                            if (ProcessManagementServiceSkeleton.this.bpelServer.getODEBPELServer().getContexts().getInMemDao().getConnection().getProcess(pId) == null) {
                                ProcessDAO newProcessDAO = ProcessManagementServiceSkeleton.this.bpelServer.getODEBPELServer().getContexts().getInMemDao().getConnection().createProcess(processDAO.getProcessId(), processDAO.getType(), processDAO.getGuid(), processDAO.getVersion());
                                Set correlatorsSet = processDAO.getCorrelatorsSet();
                                for (String correlator : correlatorsSet) {
                                    newProcessDAO.addCorrelator(correlator);
                                }
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Error occurred while updating deployment info for: " + processId;
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessManagementException(errMsg, (Throwable)e);
        }
    }

    private void persistDeployDescInFile(ProcessDeployDetailsList_type0 processDeployDetailsListType, ProcessConfigurationImpl processConf, boolean newIsInmemory) throws ProcessManagementException, IOException {
        String bpelMetafilesLocation;
        File bpelMetaDir;
        CleanUpListType cleanUpList;
        CleanUpType[] cleanUps;
        DeployDocument dd = DeployDocument.Factory.newInstance();
        TDeployment.Process process = dd.addNewDeploy().addNewProcess();
        process.setName(processConf.getProcessId());
        process.setInMemory(newIsInmemory);
        process.setActive(true);
        if (processConf.getState() == ProcessState.DISABLED) {
            process.setActive(false);
        }
        if (processConf.getState() == ProcessState.RETIRED) {
            process.setRetired(true);
        }
        ProcessEventsListType processEventsList = processDeployDetailsListType.getProcessEventsList();
        process.addNewProcessEvents();
        if (processEventsList.getEnableEventsList() != null && processEventsList.getEnableEventsList().getEnableEvent() != null) {
            String[] enabledEvents;
            EnableEventListType enableEventListType = processEventsList.getEnableEventsList();
            for (String string : enabledEvents = enableEventListType.getEnableEvent()) {
                process.getProcessEvents().addEnableEvent(string);
            }
        }
        if (processEventsList.getScopeEventsList() != null && processEventsList.getScopeEventsList().getScopeEvent() != null) {
            ScopeEventListType scopeEventListType = processEventsList.getScopeEventsList();
            ScopeEventType[] scopeEvents = scopeEventListType.getScopeEvent();
            for (String string : scopeEvents) {
                EnableEventListType enabledEventLst = string.getEnabledEventList();
                TScopeEvents tScopeEvents = process.getProcessEvents().addNewScopeEvents();
                tScopeEvents.setName(string.getScope());
                if (enabledEventLst == null || enabledEventLst.getEnableEvent() == null) continue;
                for (String event : enabledEventLst.getEnableEvent()) {
                    tScopeEvents.addEnableEvent(event);
                }
            }
        }
        if (processEventsList.getGenerate() != null) {
            String value = processEventsList.getGenerate().getValue();
            process.getProcessEvents().setGenerate(TProcessEvents.Generate.Enum.forString((String)value));
        }
        if ((cleanUps = (cleanUpList = processDeployDetailsListType.getCleanUpList()).getCleanUp()) != null) {
            for (String string : cleanUps) {
                if (!string.isOnSpecified()) continue;
                TCleanup tCleanup = process.addNewCleanup();
                String value = string.getOn().getValue();
                tCleanup.setOn(TCleanup.On.Enum.forString((String)value));
                CategoryListType categoryListType = string.getCategoryList();
                if (categoryListType == null || categoryListType.getCategory() == null) continue;
                for (Category_type1 categoryType1 : categoryListType.getCategory()) {
                    tCleanup.addCategory(TCleanup.Category.Enum.forString((String)categoryType1.getValue()));
                }
            }
        }
        if (!(bpelMetaDir = new File(bpelMetafilesLocation = this.getConfigContext().getAxisConfiguration().getRepository().getPath() + File.separator + "bpelmetafiles")).exists() && !bpelMetaDir.mkdirs()) {
            String errMsg = "Failed to create the directory: " + bpelMetaDir.getAbsolutePath();
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        String encodedPath = URLEncoder.encode(processConf.getProcessId().toString(), "UTF-8");
        File file = new File(bpelMetafilesLocation, encodedPath + ".xml");
        if (!file.exists() && !file.createNewFile()) {
            String errMsg = "Failed to create the file: " + file.getAbsolutePath();
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        dd.save(file, options);
    }

    public ProcessState getProcessState(ProcessDeployDetailsList_type0 deployDetailsListType) {
        ProcessStatus processStatus = deployDetailsListType.getProcessState();
        return ProcessState.valueOf((String)processStatus.getValue());
    }

    public void retireProcess(QName pid) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        try {
            tenantProcessStore.setState(pid, ProcessState.RETIRED);
        }
        catch (Exception e) {
            String errMsg = "Process: " + pid + " retirement failed.";
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessManagementException(errMsg, (Throwable)e);
        }
    }

    public void activateProcess(QName pid) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        try {
            tenantProcessStore.setState(pid, ProcessState.ACTIVE);
        }
        catch (Exception e) {
            String errMsg = "Process: " + pid + " activation failed.";
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessManagementException(errMsg, (Throwable)e);
        }
    }

    public ProcessInfoType getProcessInfo(QName pid) throws ProcessManagementException {
        ProcessInfoType processInfoType = new ProcessInfoType();
        TenantProcessStoreImpl tenantProcessStore = AdminServiceUtils.getTenantProcessStore();
        ProcessConf processConf = tenantProcessStore.getProcessConfiguration(pid);
        this.fillProcessInfo(processInfoType, processConf, ProcessInfoCustomizer.ALL, tenantProcessStore);
        return processInfoType;
    }

    private void fillPartnerLinks(ProcessInfoType pInfo, TDeployment.Process processInfo) throws ProcessManagementException {
        if (processInfo.getProvideList() != null) {
            EndpointReferencesType eprsType = new EndpointReferencesType();
            for (TProvide provide : processInfo.getProvideList()) {
                String plinkName = provide.getPartnerLink();
                TService service = provide.getService();
                if (service == null) {
                    String errorMsg = "Error in <provide> element for process " + processInfo.getName() + " partnerlink" + plinkName + " did not identify an endpoint";
                    log.error((Object)errorMsg);
                    throw new ProcessManagementException(errorMsg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing <provide> element for process " + processInfo.getName() + ": partnerlink " + plinkName + " --> " + service.getName() + " : " + service.getPort()));
                }
                QName serviceName = service.getName();
                EndpointRef_type0 eprType = new EndpointRef_type0();
                eprType.setPartnerLink(plinkName);
                eprType.setService(serviceName);
                ServiceLocation sLocation = new ServiceLocation();
                try {
                    String url = Utils.getTryitURL((String)serviceName.getLocalPart(), (ConfigurationContext)this.getConfigContext());
                    sLocation.addServiceLocation(url);
                }
                catch (AxisFault axisFault) {
                    String errMsg = "Error while getting try-it url for the service: " + serviceName;
                    log.error((Object)errMsg, (Throwable)axisFault);
                    throw new ProcessManagementException(errMsg, (Throwable)axisFault);
                }
                eprType.setServiceLocations(sLocation);
                eprsType.addEndpointRef(eprType);
            }
            pInfo.setEndpoints(eprsType);
        }
    }

    private Collection<ProcessConf> processQuery(ProcessFilter filter, TenantProcessStoreImpl tenantsProcessStore) throws ProcessManagementException {
        Pattern pattern;
        Map<QName, ProcessConfigurationImpl> processes = tenantsProcessStore.getProcessConfigMap();
        if (log.isDebugEnabled()) {
            for (Map.Entry<QName, ProcessConfigurationImpl> process : processes.entrySet()) {
                log.debug((Object)("Process " + process.getKey() + " in state " + process.getValue()));
            }
        }
        Set<QName> pids = processes.keySet();
        if (filter != null && filter.getNameFilter() != null) {
            String nameFilter = filter.getNameFilter().replace("\\", "\\\\").replace("]", "\\]").replace("[", "\\[").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("?", "\\?").replace(".", "\\.").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("*", ".*");
            pattern = Pattern.compile(nameFilter + "(-\\d*)?");
            CollectionsX.remove_if(pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    return !pattern.matcher(o.getLocalPart()).matches();
                }
            });
        }
        if (filter != null && filter.getNamespaceFilter() != null) {
            String namespaceFilter = filter.getNamespaceFilter().replace("\\", "\\\\").replace("]", "\\]").replace("[", "\\[").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("?", "\\?").replace(".", "\\.").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("*", ".*");
            pattern = Pattern.compile(namespaceFilter);
            CollectionsX.remove_if(pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    String ns = o.getNamespaceURI() == null ? "" : o.getNamespaceURI();
                    return !pattern.matcher(ns).matches();
                }
            });
        }
        LinkedList<ProcessConf> confs = new LinkedList<ProcessConf>();
        for (QName pid : pids) {
            ProcessConf pConf = tenantsProcessStore.getProcessConfiguration(pid);
            if (pConf == null) continue;
            confs.add(pConf);
        }
        if (filter != null) {
            if (filter.getDeployedDateFilter() != null) {
                for (final String ddf : filter.getDeployedDateFilter()) {
                    Date dd;
                    try {
                        dd = ISO8601DateParser.parse((String)Filter.getDateWithoutOp((String)ddf));
                    }
                    catch (ParseException e) {
                        String errMsg = "Exception while parsing date";
                        log.error((Object)errMsg, (Throwable)e);
                        throw new ProcessManagementException(errMsg, (Throwable)e);
                    }
                    CollectionsX.remove_if(confs, (MemberOfFunction)new MemberOfFunction<ProcessConf>(){

                        public boolean isMember(ProcessConf o) {
                            if (ddf.startsWith("=")) {
                                return !o.getDeployDate().equals(dd);
                            }
                            if (ddf.startsWith("<=")) {
                                return o.getDeployDate().getTime() > dd.getTime();
                            }
                            if (ddf.startsWith(">=")) {
                                return o.getDeployDate().getTime() < dd.getTime();
                            }
                            if (ddf.startsWith("<")) {
                                return o.getDeployDate().getTime() >= dd.getTime();
                            }
                            return ddf.startsWith(">") && o.getDeployDate().getTime() <= dd.getTime();
                        }
                    });
                }
            }
            if (filter.getOrders() != null) {
                ComparatorChain cChain = new ComparatorChain();
                for (String key : filter.getOrders()) {
                    Comparator<ProcessConf> c;
                    boolean ascending = true;
                    String orderKey = key;
                    if (key.startsWith("+") || key.startsWith("-")) {
                        orderKey = key.substring(1, key.length());
                        if (key.startsWith("-")) {
                            ascending = false;
                        }
                    }
                    if ("name".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getProcessId().getLocalPart().compareTo(o2.getProcessId().getLocalPart());
                            }
                        };
                    } else if ("namespace".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                String ns1 = o1.getProcessId().getNamespaceURI() == null ? "" : o1.getProcessId().getNamespaceURI();
                                String ns2 = o2.getProcessId().getNamespaceURI() == null ? "" : o2.getProcessId().getNamespaceURI();
                                return ns1.compareTo(ns2);
                            }
                        };
                    } else if ("version".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return (int)(o1.getVersion() - o2.getVersion());
                            }
                        };
                    } else if ("deployed".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getDeployDate().compareTo(o2.getDeployDate());
                            }
                        };
                    } else if ("status".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getState().compareTo((Enum)o2.getState());
                            }
                        };
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("unrecognized order key" + orderKey));
                        continue;
                    }
                    cChain.addComparator((Comparator)c, !ascending);
                }
                Collections.sort(confs, cChain);
            }
        }
        return confs;
    }

    private void fillProcessInfo(ProcessInfoType info, ProcessConf pconf, ProcessInfoCustomizer custom, TenantProcessStoreImpl tenantProcessStore) throws ProcessManagementException {
        if (pconf == null) {
            String errMsg = "Process configuration cannot be null.";
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        info.setPid(pconf.getProcessId().toString());
        if (pconf.getState() == ProcessState.RETIRED) {
            info.setStatus(ProcessStatus.RETIRED);
            info.setOlderVersion(AdminServiceUtils.isOlderVersion(pconf, tenantProcessStore));
        } else if (pconf.getState() == ProcessState.DISABLED) {
            info.setStatus(ProcessStatus.DISABLED);
            info.setOlderVersion(0);
        } else {
            info.setStatus(ProcessStatus.ACTIVE);
            info.setOlderVersion(0);
        }
        info.setVersion(pconf.getVersion());
        DefinitionInfo defInfo = new DefinitionInfo();
        defInfo.setProcessName(pconf.getType());
        BpelDefinition bpelDefinition = new BpelDefinition();
        bpelDefinition.setExtraElement(this.getProcessDefinition(pconf));
        defInfo.setDefinition(bpelDefinition);
        info.setDefinitionInfo(defInfo);
        DeploymentInfo depInfo = new DeploymentInfo();
        depInfo.setPackageName(pconf.getPackage());
        depInfo.setDocument(pconf.getBpelDocument());
        depInfo.setDeployDate(AdminServiceUtils.toCalendar(pconf.getDeployDate()));
        depInfo.setDeployer("BPELDeployer");
        info.setDeploymentInfo(depInfo);
        if (custom.includeInstanceSummary()) {
            InstanceSummary instanceSummary = new InstanceSummary();
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.ACTIVE);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.COMPLETED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.FAILED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.SUSPENDED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.TERMINATED);
            this.addFailuresToInstanceSummary(instanceSummary, pconf);
            info.setInstanceSummary(instanceSummary);
        }
        if (custom.includeProcessProperties()) {
            ProcessProperties processProps = new ProcessProperties();
            for (Map.Entry propEntry : pconf.getProcessProperties().entrySet()) {
                QName key = (QName)propEntry.getKey();
                if (key == null) continue;
                Property_type0 prop = new Property_type0();
                prop.setName(new QName(key.getNamespaceURI(), key.getLocalPart()));
                OMFactory omFac = OMAbstractFactory.getOMFactory();
                OMElement propEle = omFac.createOMElement("PropertyValue", null);
                propEle.setText(((Node)propEntry.getValue()).getNodeValue());
                prop.addExtraElement(propEle);
                processProps.addProperty(prop);
            }
            info.setProperties(processProps);
        }
        this.fillPartnerLinks(info, ((ProcessConfigurationImpl)pconf).getProcessDeploymentInfo());
    }

    private void addInstanceSummaryEntry(InstanceSummary instSum, ProcessConf pconf, InstanceStatus state) throws ProcessManagementException {
        Instances_type0 instances = new Instances_type0();
        instances.setState(state);
        String queryStatus = InstanceFilter.StatusKeys.valueOf((String)state.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + queryStatus + " pid=" + pconf.getProcessId());
        int count = this.dbexec(new BpelDatabase.Callable<Integer>(){

            public Integer run(BpelDAOConnection conn) throws Exception {
                return conn.instanceQuery(instanceFilter).size();
            }
        });
        instances.setCount(count);
        instSum.addInstances(instances);
    }

    private void addFailuresToInstanceSummary(final InstanceSummary instSum, ProcessConf pconf) throws ProcessManagementException {
        final FailuresInfo failureInfo = new FailuresInfo();
        String queryStatus = InstanceFilter.StatusKeys.valueOf((String)TInstanceStatus.ACTIVE.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + queryStatus + " pid=" + pconf.getProcessId());
        this.dbexec(new BpelDatabase.Callable<Void>(){

            public Void run(BpelDAOConnection conn) throws Exception {
                Date lastFailureDt = null;
                int failureInstances = 0;
                for (ProcessInstanceDAO instance : conn.instanceQuery(instanceFilter)) {
                    int count = instance.getActivityFailureCount();
                    if (count <= 0) continue;
                    ++failureInstances;
                    Date failureDt = instance.getActivityFailureDateTime();
                    if (lastFailureDt != null && !lastFailureDt.before(failureDt)) continue;
                    lastFailureDt = failureDt;
                }
                if (failureInstances > 0) {
                    failureInfo.setCount(failureInstances);
                    failureInfo.setFailureDate(AdminServiceUtils.toCalendar(lastFailureDt));
                    instSum.setFailures(failureInfo);
                }
                return null;
            }
        });
    }

    protected <T> T dbexec(BpelDatabase.Callable<T> callable) throws ProcessManagementException {
        try {
            return (T)this.bpelDb.exec(callable);
        }
        catch (Exception ex) {
            String errMsg = "Exception during database operation ";
            log.error((Object)errMsg, (Throwable)ex);
            throw new ProcessManagementException(errMsg, (Throwable)ex);
        }
    }

    private OMElement getProcessDefinition(ProcessConf pConf) throws ProcessManagementException {
        if (pConf == null) {
            String errMsg = "Process configuration cannot be null.";
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        String bpelDoc = pConf.getBpelDocument();
        List files = pConf.getFiles();
        for (File file : files) {
            OMElement bpelDefinition;
            if (!file.getPath().endsWith(bpelDoc) && !file.getPath().endsWith(bpelDoc.replaceAll("/", "\\\\"))) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader reader = xif.createXMLStreamReader(fis);
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                bpelDefinition = builder.getDocumentElement();
                bpelDefinition.build();
            }
            catch (XMLStreamException e) {
                String errMsg = "XML stream reader exception: " + file.getAbsolutePath();
                log.error((Object)errMsg, (Throwable)e);
                throw new ProcessManagementException(errMsg, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                String errMsg = "BPEL File reading exception: " + file.getAbsolutePath();
                log.error((Object)errMsg, (Throwable)e);
                throw new ProcessManagementException(errMsg, (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Cannot close file input stream.", (Throwable)e);
                    }
                }
            }
            return bpelDefinition;
        }
        String errMsg = "Process Definition for: " + pConf.getProcessId() + " not found";
        log.error((Object)errMsg);
        throw new ProcessManagementException(errMsg);
    }
}

