/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.core.ode.integration;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.epr.WSDL11Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.bpel.core.ode.integration.BPELFault;
import org.wso2.carbon.bpel.core.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.core.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.core.ode.integration.HTTPBindingHandler;
import org.wso2.carbon.bpel.core.ode.integration.axis2.WSDLAwareSOAPProcessor;
import org.wso2.carbon.bpel.core.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.core.ode.integration.utils.AxisServiceUtils;
import org.wso2.carbon.bpel.core.ode.integration.utils.BPELMessageContextFactory;
import org.wso2.carbon.bpel.core.ode.integration.utils.Messages;
import org.wso2.carbon.bpel.core.ode.integration.utils.SOAPUtils;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;

public class PartnerService
implements PartnerRoleChannel {
    private static final Log log = LogFactory.getLog(PartnerService.class);
    private static Log messageTraceLog = LogFactory.getLog((String)"org.wso2.carbon.bpel.messagetrace");
    private Definition wsdlDefinition;
    private QName serviceName;
    private String portName;
    private ConfigurationContext clientConfigCtx;
    private ProcessConf processConfiguration;
    private WSAEndpoint endpointReference;
    private String endpointUrl;
    private Binding binding;
    private UnifiedEndpoint uep;

    public PartnerService(Definition wsdlDefinition, QName serviceName, String portName, ConfigurationContext clientConfigCtx, ProcessConf pconf, HttpConnectionManager connManager) throws AxisFault {
        this.wsdlDefinition = wsdlDefinition;
        this.serviceName = serviceName;
        this.portName = portName;
        this.clientConfigCtx = clientConfigCtx;
        this.processConfiguration = pconf;
        this.inferBindingInformation();
        this.clientConfigCtx.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
        this.clientConfigCtx.setProperty("REUSE_HTTP_CLIENT", (Object)"false");
        Element eprEle = BPELProcessProxy.genEPRfromWSDL(this.wsdlDefinition, this.serviceName, this.portName);
        if (eprEle == null) {
            throw new IllegalArgumentException("Service Port definition not found for service:" + this.serviceName + " and port:" + this.portName);
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)BPELProcessProxy.createServiceRef(eprEle));
        this.endpointUrl = this.endpointReference.getUrl();
        this.initUEP();
    }

    private void initUEP() throws AxisFault {
        EndpointConfiguration endpointConf = ((ProcessConfigurationImpl)this.processConfiguration).getEndpointConfiguration((EndpointReference)new WSDL11Endpoint(this.serviceName, this.portName));
        if (endpointConf == null) {
            this.uep = new UnifiedEndpoint();
            this.uep.setUepId(this.serviceName.getLocalPart());
            this.uep.setAddressingEnabled(true);
            this.uep.setAddressingVersion("final");
        } else {
            this.uep = endpointConf.getUnifiedEndpoint();
        }
    }

    public Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public Binding getBinding() {
        return this.binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(PartnerRoleMessageExchange partnerRoleMessageExchange) {
        boolean isTwoWay = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        try {
            MessageContext mctx = new MessageContext();
            BPELMessageContext partnerInvocationContext = BPELMessageContextFactory.createBPELMessageContext(mctx, this);
            ExtensibilityElement bindingType = WSDLAwareSOAPProcessor.getBindingExtension(this.binding);
            try {
                String mexEndpointUrl;
                if (bindingType instanceof HTTPBinding) {
                    if (this.uep.getAddress() == null) {
                        this.uep.setAddress(this.endpointUrl);
                    }
                    partnerInvocationContext.setUep(this.uep);
                    partnerInvocationContext.setTwoWay(isTwoWay);
                    partnerInvocationContext.setService(this.serviceName);
                    partnerInvocationContext.setPort(this.portName);
                    partnerInvocationContext.setCaller(partnerRoleMessageExchange.getCaller().getLocalPart());
                    partnerInvocationContext.setOperationName(partnerRoleMessageExchange.getOperationName());
                    SOAPUtils.createSOAPRequest(partnerInvocationContext, partnerRoleMessageExchange);
                    mexEndpointUrl = ((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl();
                    if (!this.endpointUrl.equals(mexEndpointUrl)) {
                        this.uep.setAddress(mexEndpointUrl);
                    }
                    if (messageTraceLog.isDebugEnabled()) {
                        messageTraceLog.debug((Object)("Invoking service: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + this.serviceName + "." + partnerRoleMessageExchange.getOperationName()));
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Request message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + partnerInvocationContext.getInMessageContext().getEnvelope()));
                        }
                    }
                    HTTPBindingHandler httpBindingHandler = new HTTPBindingHandler(this.clientConfigCtx, this.serviceName, this.portName, this.wsdlDefinition);
                    HTTPBindingHandler.HTTPBindingResponse response = httpBindingHandler.invoke(partnerRoleMessageExchange, partnerInvocationContext);
                    if (isTwoWay) {
                        MessageContext responseMessageContext = response.getReponseMessageContext();
                        partnerInvocationContext.setOutMessageContext(responseMessageContext);
                        MessageContext fltMessageContext = response.getFaultMessageContext();
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Response message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + responseMessageContext.getEnvelope()));
                        }
                        if (fltMessageContext != null) {
                            this.replyHTTP(partnerInvocationContext, partnerRoleMessageExchange, true);
                        } else {
                            this.replyHTTP(partnerInvocationContext, partnerRoleMessageExchange, response.isFault());
                        }
                    } else {
                        partnerRoleMessageExchange.replyOneWayOk();
                    }
                } else {
                    if (this.uep.getAddress() == null) {
                        this.uep.setAddress(this.endpointUrl);
                    }
                    partnerInvocationContext.setUep(this.uep);
                    partnerInvocationContext.setTwoWay(isTwoWay);
                    partnerInvocationContext.setService(this.serviceName);
                    partnerInvocationContext.setPort(this.portName);
                    partnerInvocationContext.setCaller(partnerRoleMessageExchange.getCaller().getLocalPart());
                    partnerInvocationContext.setOperationName(partnerRoleMessageExchange.getOperationName());
                    SOAPUtils.createSOAPRequest(partnerInvocationContext, partnerRoleMessageExchange);
                    mexEndpointUrl = ((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl();
                    if (!this.endpointUrl.equals(mexEndpointUrl)) {
                        this.uep.setAddress(mexEndpointUrl);
                    }
                    if (messageTraceLog.isDebugEnabled()) {
                        messageTraceLog.debug((Object)("Invoking service: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + this.serviceName + "." + partnerRoleMessageExchange.getOperationName()));
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Request message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + partnerInvocationContext.getInMessageContext().getEnvelope()));
                        }
                    }
                    AxisServiceUtils.invokeService(partnerInvocationContext, this.clientConfigCtx);
                    if (messageTraceLog.isDebugEnabled()) {
                        messageTraceLog.debug((Object)("Service invocation completed: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + this.serviceName + "." + partnerRoleMessageExchange.getOperationName()));
                    }
                    if (isTwoWay) {
                        Operation operation = partnerRoleMessageExchange.getOperation();
                        MessageContext response = partnerInvocationContext.getOutMessageContext();
                        MessageContext flt = partnerInvocationContext.getFaultMessageContext();
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Response message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + response.getEnvelope()));
                        }
                        if (flt != null) {
                            this.reply(partnerInvocationContext, partnerRoleMessageExchange, operation, flt, true);
                        } else {
                            this.reply(partnerInvocationContext, partnerRoleMessageExchange, operation, response, response.isFault());
                        }
                    } else {
                        partnerRoleMessageExchange.replyOneWayOk();
                    }
                }
            }
            finally {
                TransportOutDescription out = mctx.getTransportOut();
                if (out != null && out.getSender() != null) {
                    out.getSender().cleanup(mctx);
                }
            }
        }
        catch (Exception e) {
            String errmsg = Messages.msgErrorSendingMessageToAxisForODEMex(partnerRoleMessageExchange.toString());
            log.error((Object)errmsg, (Throwable)e);
            this.replyWithFailure(partnerRoleMessageExchange, MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg);
        }
    }

    private void inferBindingInformation() {
        Service serviceDef = this.wsdlDefinition.getService(this.serviceName);
        if (serviceDef == null) {
            throw new NullPointerException(Messages.msgServiceDefinitionNotFound(this.serviceName.getLocalPart()));
        }
        Port port = serviceDef.getPort(this.portName);
        if (port == null) {
            throw new NullPointerException(Messages.msgServicePortNotFound(this.serviceName.getLocalPart(), this.portName));
        }
        this.binding = port.getBinding();
        if (this.binding == null) {
            throw new NullPointerException(Messages.msgBindingNotFound(this.serviceName.getLocalPart(), this.portName));
        }
    }

    private void replyWithFailure(PartnerRoleMessageExchange odeMex, MessageExchange.FailureType error, String errmsg) {
        try {
            odeMex.replyWithFailure(error, errmsg, null);
        }
        catch (Exception e) {
            String emsg = "Error executing replyWithFailure; reply will be lost.";
            log.error((Object)emsg, (Throwable)e);
        }
    }

    private void reply(BPELMessageContext partnerInvocationContext, PartnerRoleMessageExchange odeMex, Operation operation, MessageContext reply, boolean isFault) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + odeMex));
            }
            if (isFault) {
                Document odeMsg = DOMUtils.newDocument();
                Element odeMsgEl = odeMsg.createElementNS(null, "message");
                odeMsg.appendChild(odeMsgEl);
                Fault fault = SOAPUtils.parseSoapFault(odeMsgEl, reply.getEnvelope(), operation);
                if (fault != null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMUtils.domToString((Node)odeMsgEl)));
                    }
                    QName faultType = fault.getMessage().getQName();
                    QName faultName = new QName(this.wsdlDefinition.getTargetNamespace(), fault.getName());
                    Message response = odeMex.createMessage(faultType);
                    response.setMessage(odeMsgEl);
                    odeMex.replyWithFault(faultName, response);
                } else {
                    SOAPFault soapFault = reply.getEnvelope().getBody().getFault();
                    QName faultType = new QName(this.wsdlDefinition.getTargetNamespace(), "UnknownFault");
                    Message response = odeMex.createMessage(faultType);
                    Element actAsPart = odeMsgEl.getOwnerDocument().createElementNS(null, soapFault.getLocalName());
                    odeMsgEl.appendChild(actAsPart);
                    if (soapFault.getCode() != null) {
                        actAsPart.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)soapFault.getCode()), true));
                    }
                    if (soapFault.getReason() != null) {
                        actAsPart.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)soapFault.getReason()), true));
                    }
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Fault response: " + DOMUtils.domToString((Node)odeMsgEl)));
                    }
                    response.setMessage(odeMsgEl);
                    odeMex.replyWithFault(faultType, response);
                }
            } else {
                Message response = SOAPUtils.parseSOAPResponseFromPartner(partnerInvocationContext, (MessageExchange)odeMex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                }
                odeMex.reply(response);
            }
        }
        catch (BPELFault bpelFault) {
            this.handleError(odeMex, (Exception)((Object)bpelFault));
        }
        catch (AxisFault axisFault) {
            this.handleError(odeMex, (Exception)((Object)axisFault));
        }
    }

    private void handleError(PartnerRoleMessageExchange odeMex, Exception ex) {
        String errmsg = "Unable to process response: " + ex.getMessage();
        log.error((Object)errmsg, (Throwable)ex);
        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
    }

    private void replyHTTP(BPELMessageContext partnerInvocationContext, PartnerRoleMessageExchange odeMex, boolean isFault) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + odeMex));
            }
            if (isFault) {
                Document odeMsg = DOMUtils.newDocument();
                Element odeMsgEl = odeMsg.createElementNS(null, "message");
                odeMsg.appendChild(odeMsgEl);
                QName faultType = new QName("http://wso2.org/bps/fault", "HTTPBindingFault");
                QName faultName = new QName("http://wso2.org/bps/fault", "RESTPartnerServiceError");
                Element fault = odeMsg.createElementNS(null, "fault");
                fault.setTextContent("Error returned from REST Partner");
                odeMsgEl.appendChild(fault);
                Message response = odeMex.createMessage(faultType);
                response.setMessage(odeMsgEl);
                odeMex.replyWithFault(faultName, response);
            } else {
                Message response = SOAPUtils.parseResponseFromRESTService(partnerInvocationContext, odeMex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                }
                odeMex.reply(response);
            }
        }
        catch (Exception ex) {
            String errmsg = "Unable to process response: " + ex.getMessage();
            log.error((Object)errmsg, (Throwable)ex);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
        }
    }

    public EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void close() {
    }
}

