/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.model.ClassHierarchyContext;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NameAttributes;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.TemplateElement;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValidationProblem;
import org.jibx.runtime.Utility;
import org.jibx.util.IClass;

public class DefinitionContext {
    private final DefinitionContext m_outerContext;
    private NamespaceElement m_attributeDefault;
    private NamespaceElement m_elementDefault;
    private ArrayList m_namespaces;
    private HashMap m_prefixMap;
    private HashMap m_uriMap;
    private HashMap m_mappingMap;
    private ClassHierarchyContext m_formatContext;
    private ClassHierarchyContext m_templateContext;
    private HashMap m_namedStructureMap;

    protected DefinitionContext(DefinitionContext outer) {
        this.m_outerContext = outer;
    }

    DefinitionContext getIncludeCopy() {
        DefinitionContext dupl = new DefinitionContext(this.m_outerContext);
        if (this.m_mappingMap == null) {
            this.m_mappingMap = new HashMap();
        }
        dupl.m_mappingMap = this.m_mappingMap;
        if (this.m_formatContext == null) {
            this.m_formatContext = new ClassHierarchyContext(this.getContainingFormatContext());
        }
        dupl.m_formatContext = this.m_formatContext;
        if (this.m_templateContext == null) {
            this.m_templateContext = new ClassHierarchyContext(this.getContainingTemplateContext());
        }
        dupl.m_templateContext = this.m_templateContext;
        return dupl;
    }

    void injectNamespaces(DefinitionContext to) {
        to.m_attributeDefault = this.m_attributeDefault;
        to.m_elementDefault = this.m_elementDefault;
        if (this.m_namespaces != null) {
            to.m_namespaces = new ArrayList(this.m_namespaces);
            to.m_prefixMap = new HashMap(this.m_prefixMap);
            to.m_uriMap = new HashMap(this.m_uriMap);
        }
    }

    public DefinitionContext getContaining() {
        return this.m_outerContext;
    }

    private ClassHierarchyContext getContainingFormatContext() {
        if (this.m_outerContext == null) {
            return null;
        }
        return this.m_outerContext.getFormatContext();
    }

    private ClassHierarchyContext getFormatContext() {
        if (this.m_formatContext == null) {
            return this.getContainingFormatContext();
        }
        return this.m_formatContext;
    }

    private ClassHierarchyContext getContainingTemplateContext() {
        if (this.m_outerContext == null) {
            return null;
        }
        return this.m_outerContext.getTemplateContext();
    }

    private ClassHierarchyContext getTemplateContext() {
        if (this.m_templateContext == null) {
            return this.getContainingTemplateContext();
        }
        return this.m_templateContext;
    }

    public NamespaceElement getNamespaceForPrefix(String prefix) {
        if (this.m_prefixMap == null) {
            return null;
        }
        return (NamespaceElement)this.m_prefixMap.get(prefix);
    }

    private NamespaceElement checkDuplicatePrefix(NamespaceElement def) {
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
            this.m_prefixMap = new HashMap();
            this.m_uriMap = new HashMap();
        }
        String prefix = def.getPrefix();
        return (NamespaceElement)this.m_prefixMap.get(prefix);
    }

    private void internalAddNamespace(NamespaceElement def) {
        String uri = def.getUri();
        String prefix = def.getPrefix();
        this.m_namespaces.add(def);
        this.m_prefixMap.put(prefix, def);
        this.m_uriMap.put(uri, def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationProblem addNamespace(NamespaceElement def) {
        String uri = def.getUri();
        NamespaceElement dup = this.checkDuplicatePrefix(def);
        if (dup == null || uri.equals(dup.getUri())) {
            if (def.isAttributeDefault()) {
                if (this.m_attributeDefault != null) return new ValidationProblem("Conflicting attribute namespaces", def);
                this.m_attributeDefault = def;
            }
            if (def.isElementDefault()) {
                if (this.m_elementDefault != null) return new ValidationProblem("Conflicting element namespaces", def);
                this.m_elementDefault = def;
            }
        } else {
            String prefix = def.getPrefix();
            if (prefix != null) return new ValidationProblem("Namespace prefix conflict for prefix '" + prefix + '\'', def);
            return new ValidationProblem("Default namespace conflict", def);
        }
        this.internalAddNamespace(def);
        return null;
    }

    public ValidationProblem addImpliedNamespace(NamespaceElement def, ElementBase ref) {
        String uri = def.getUri();
        NamespaceElement dup = this.checkDuplicatePrefix(def);
        DefinitionContext ctx = this;
        String prefix = def.getPrefix();
        while (dup == null && (ctx = ctx.getContaining()) != null) {
            dup = this.getNamespaceForPrefix(prefix);
        }
        if (dup == null) {
            NamespaceElement prior = (NamespaceElement)this.m_uriMap.get(uri);
            if (prior == null || prior.getPrefix() == null) {
                this.internalAddNamespace(def);
            }
        } else if (!uri.equals(dup.getUri())) {
            if (prefix == null) {
                return new ValidationProblem("Default namespace conflict on mapping reference", ref);
            }
            return new ValidationProblem("Namespace conflict on mapping reference, for prefix '" + prefix + '\'', ref);
        }
        return null;
    }

    public NamespaceElement getElementNamespace(NameAttributes name, ValidationContext vctx) {
        NamespaceElement cns;
        String uri = name.getUri();
        String prefix = name.getPrefix();
        NamespaceElement ns = null;
        if (uri != null) {
            if (this.m_uriMap != null && (ns = (NamespaceElement)this.m_uriMap.get(uri)) != null) {
                if (prefix == null) {
                    prefix = ns.getPrefix();
                } else if (!prefix.equals(ns.getPrefix())) {
                    ns = null;
                }
            }
        } else if (prefix != null) {
            if (this.m_prefixMap != null) {
                ns = (NamespaceElement)this.m_prefixMap.get(prefix);
            }
        } else {
            ns = this.m_elementDefault;
        }
        if (!(ns != null || this.m_outerContext == null || (ns = this.m_outerContext.getElementNamespace(name, vctx)) == null || this.m_prefixMap == null || (cns = (NamespaceElement)this.m_prefixMap.get(ns.getPrefix())) == null || ns == cns || Utility.safeEquals(ns.getUri(), cns.getUri()) && Utility.safeEquals(ns.getPrefix(), cns.getPrefix()))) {
            StringBuffer buff = new StringBuffer();
            if (uri == null) {
                buff.append("Unable to use non-namespaced elements because namespace '");
                buff.append(cns.getUri());
                buff.append("' is the default");
            } else {
                buff.append("Unable to use namespace URI '");
                buff.append(uri);
                buff.append("' due to prefix conflict with namespace '");
                buff.append(cns.getUri());
                buff.append('\'');
            }
            vctx.addError(buff.toString());
        }
        return ns;
    }

    public NamespaceElement getAttributeNamespace(NameAttributes name) {
        String uri = name.getUri();
        String prefix = name.getPrefix();
        NamespaceElement ns = null;
        if (uri != null) {
            if (this.m_uriMap != null && (ns = (NamespaceElement)this.m_uriMap.get(uri)) != null && prefix != null && !prefix.equals(ns.getPrefix())) {
                ns = null;
            }
        } else if (prefix != null) {
            if (this.m_prefixMap != null) {
                ns = (NamespaceElement)this.m_prefixMap.get(prefix);
            }
        } else {
            ns = this.m_attributeDefault;
        }
        if (ns == null && this.m_outerContext != null) {
            ns = this.m_outerContext.getAttributeNamespace(name);
        }
        return ns;
    }

    public void addFormat(FormatElement def, ValidationContext vctx) {
        String label;
        if (this.m_formatContext == null) {
            this.m_formatContext = new ClassHierarchyContext(this.getContainingFormatContext());
        }
        if (def.isDefaultFormat()) {
            IClass clas = def.getType();
            this.m_formatContext.addTypedComponent(clas, def, vctx);
        }
        if ((label = def.getLabel()) != null) {
            this.m_formatContext.addNamedComponent(label, def, vctx);
        }
    }

    public FormatElement getSpecificFormat(String type) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getSpecificComponent(type);
    }

    public FormatElement getNamedFormat(String name) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getNamedComponent(name);
    }

    public FormatElement getBestFormat(IClass clas) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getMostSpecificComponent(clas);
    }

    public void addMappedName(NameAttributes name, MappingElementBase def, ValidationContext vctx) {
        if (this.m_mappingMap == null) {
            this.m_mappingMap = new HashMap();
        }
        String fullname = name.getName();
        NamespaceElement namespace = this.getElementNamespace(name, vctx);
        if (namespace != null && namespace.getUri() != null) {
            fullname = '{' + namespace.getUri() + '}' + fullname;
        }
        if (this.m_mappingMap.containsKey(fullname)) {
            if (vctx.isInBinding()) {
                vctx.addError("Duplicate mapping name not allowed for unmarshalling");
            }
        } else {
            this.m_mappingMap.put(fullname, def);
        }
    }

    public void addTemplate(TemplateElementBase def, ValidationContext vctx) {
        if (this.m_templateContext == null) {
            this.m_templateContext = new ClassHierarchyContext(this.getContainingTemplateContext());
        }
        if (def.isDefaultTemplate()) {
            IClass clas = def.getHandledClass();
            this.m_templateContext.addTypedComponent(clas, def, vctx);
        }
        if (def instanceof TemplateElement) {
            TemplateElement tdef = (TemplateElement)def;
            if (tdef.getLabel() != null) {
                this.m_templateContext.addNamedComponent(tdef.getLabel(), def, vctx);
            }
        } else {
            MappingElementBase mdef = (MappingElementBase)def;
            if (mdef.getTypeName() != null) {
                this.m_templateContext.addNamedComponent(mdef.getTypeName(), def, vctx);
            }
        }
    }

    public TemplateElementBase getSpecificTemplate(String type) {
        ClassHierarchyContext ctx = this.getTemplateContext();
        if (ctx == null) {
            return null;
        }
        return (TemplateElementBase)ctx.getSpecificComponent(type);
    }

    public TemplateElementBase getNamedTemplate(String name) {
        ClassHierarchyContext ctx = this.getTemplateContext();
        if (ctx == null) {
            return null;
        }
        return (TemplateElementBase)ctx.getNamedComponent(name);
    }

    public boolean isCompatibleTemplateType(IClass clas) {
        ClassHierarchyContext chctx = this.getTemplateContext();
        if (chctx == null) {
            return false;
        }
        return chctx.isCompatibleType(clas);
    }

    public ValidationProblem addNamedStructure(ContainerElementBase def) {
        String label;
        if (this.m_namedStructureMap == null) {
            this.m_namedStructureMap = new HashMap();
        }
        if (this.m_namedStructureMap.get(label = def.getLabel()) == null) {
            this.m_namedStructureMap.put(label, def);
            return null;
        }
        return new ValidationProblem("Duplicate label \"" + label + '\"', def);
    }

    public ContainerElementBase getNamedStructure(String label) {
        if (this.m_namedStructureMap == null) {
            return null;
        }
        return (ContainerElementBase)this.m_namedStructureMap.get(label);
    }

    public ArrayList getNamespaces() {
        return this.m_namespaces;
    }
}

