/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.springframework.xml.xsd.commons.CommonsXsdSchema;

public class CommonsXsdSchemaCollection
implements XsdSchemaCollection,
InitializingBean {
    private final XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
    private final List xmlSchemas = new ArrayList();
    private Resource[] xsdResources;
    private boolean inline = false;
    private ValidationEventHandler validationEventHandler;

    public CommonsXsdSchemaCollection() {
    }

    public CommonsXsdSchemaCollection(Resource[] resources) {
        this.xsdResources = resources;
    }

    public void setXsds(Resource[] xsdResources) {
        this.xsdResources = xsdResources;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void afterPropertiesSet() throws IOException {
        Assert.notEmpty(this.xsdResources, "'xsds' must not be empty");
        HashSet processedIncludes = new HashSet();
        HashSet processedImports = new HashSet();
        for (int i = 0; i < this.xsdResources.length; ++i) {
            Assert.isTrue(this.xsdResources[i].exists(), this.xsdResources[i] + " does not exit");
            XmlSchema xmlSchema = this.schemaCollection.read(SaxUtils.createInputSource(this.xsdResources[i]), this.validationEventHandler);
            this.xmlSchemas.add(xmlSchema);
            if (!this.inline) continue;
            this.inlineIncludes(xmlSchema, processedIncludes, processedImports);
            this.findImports(xmlSchema, processedImports, processedIncludes);
        }
    }

    public XsdSchema[] getXsdSchemas() {
        XsdSchema[] result = new XsdSchema[this.xmlSchemas.size()];
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema xmlSchema = (XmlSchema)this.xmlSchemas.get(i);
            result[i] = new CommonsXsdSchema(xmlSchema);
        }
        return result;
    }

    public XmlValidator createValidator() throws IOException {
        Resource[] resources = new Resource[this.xmlSchemas.size()];
        for (int i = this.xmlSchemas.size() - 1; i >= 0; --i) {
            XmlSchema xmlSchema = (XmlSchema)this.xmlSchemas.get(i);
            resources[i] = new UrlResource(xmlSchema.getSourceURI());
        }
        return XmlValidatorFactory.createValidator(resources, "http://www.w3.org/2001/XMLSchema");
    }

    private void inlineIncludes(XmlSchema schema, Set processedIncludes, Set processedImports) {
        processedIncludes.add(schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        for (int i = 0; i < includes.getCount(); ++i) {
            XmlSchemaExternal external = (XmlSchemaExternal)includes.getItem(i);
            if (!(external instanceof XmlSchemaInclude)) continue;
            XmlSchema includedSchema = external.getSchema();
            XmlSchemaObjectCollection items = schema.getItems();
            if (!processedIncludes.contains(includedSchema)) {
                this.inlineIncludes(includedSchema, processedIncludes, processedImports);
                this.findImports(includedSchema, processedImports, processedIncludes);
                XmlSchemaObjectCollection includeItems = includedSchema.getItems();
                for (int j = 0; j < includeItems.getCount(); ++j) {
                    XmlSchemaObject includedItem = includeItems.getItem(j);
                    items.add(includedItem);
                }
            }
            items.remove((XmlSchemaObject)external);
        }
    }

    private void findImports(XmlSchema schema, Set processedImports, Set processedIncludes) {
        processedImports.add(schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        for (int i = 0; i < includes.getCount(); ++i) {
            XmlSchemaExternal external = (XmlSchemaExternal)includes.getItem(i);
            if (!(external instanceof XmlSchemaImport)) continue;
            XmlSchemaImport schemaImport = (XmlSchemaImport)external;
            XmlSchema importedSchema = schemaImport.getSchema();
            if (!"http://www.w3.org/XML/1998/namespace".equals(schemaImport.getNamespace()) && importedSchema != null && !processedImports.contains(importedSchema)) {
                this.inlineIncludes(importedSchema, processedIncludes, processedImports);
                this.findImports(importedSchema, processedImports, processedIncludes);
                this.xmlSchemas.add(importedSchema);
            }
            external.setSchemaLocation(null);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("CommonsXsdSchemaCollection");
        buffer.append('{');
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)this.xmlSchemas.get(i);
            buffer.append(schema.getTargetNamespace());
            if (i >= this.xmlSchemas.size() - 1) continue;
            buffer.append(',');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

