/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.xpath.JaxenXPathExpressionFactory;
import org.springframework.xml.xpath.Jaxp13XPathExpressionFactory;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathParseException;

public abstract class XPathExpressionFactory {
    private static final Log logger = LogFactory.getLog((Class)XPathExpressionFactory.class);
    private static final String JAXEN_CLASS_NAME = "org.jaxen.XPath";
    private static boolean jaxp13Available = JaxpVersion.isAtLeastJaxp13();
    private static boolean jaxenAvailable;

    public static XPathExpression createXPathExpression(String expression) throws IllegalStateException, XPathParseException {
        return XPathExpressionFactory.createXPathExpression(expression, Collections.EMPTY_MAP);
    }

    public static XPathExpression createXPathExpression(String expression, Map namespaces) throws IllegalStateException, XPathParseException {
        Assert.hasLength(expression, "expression is empty");
        if (jaxp13Available) {
            try {
                logger.trace((Object)"Creating [javax.xml.xpath.XPathExpression]");
                return Jaxp13XPathExpressionFactory.createXPathExpression(expression, namespaces);
            }
            catch (XPathException e) {
                throw e;
            }
            catch (Throwable e) {
                jaxp13Available = false;
            }
        }
        if (jaxenAvailable) {
            logger.trace((Object)"Creating [org.jaxen.XPath]");
            return JaxenXPathExpressionFactory.createXPathExpression(expression, namespaces);
        }
        throw new IllegalStateException("Could not create XPathExpression: could not locate JAXP 1.3, or Jaxen on the class path");
    }

    static {
        try {
            ClassUtils.forName(JAXEN_CLASS_NAME);
            jaxenAvailable = true;
        }
        catch (ClassNotFoundException ex) {
            jaxenAvailable = false;
        }
    }
}

